<?php
require_once '../auth.php';

if (!$auth->isLoggedIn()) {
    header('Content-Type: application/json');
    echo json_encode(['error' => 'Not authenticated']);
    exit;
}

header('Content-Type: application/json');

try {
    $user_id = $_SESSION['user_id'];
    $stmt = $pdo->prepare("SELECT * FROM ai_agents WHERE user_id = ? ORDER BY is_default DESC, name ASC");
    $stmt->execute([$user_id]);
    $agents = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode(['agents' => $agents]);
} catch (Exception $e) {
    error_log("Error in get_agents.php: " . $e->getMessage());
    echo json_encode(['error' => 'Failed to load agents']);
}
?>