<?php
require_once '../auth.php';

if (!$auth->isLoggedIn()) {
    echo json_encode(['error' => 'Not authenticated']);
    exit;
}

$user_id = $_SESSION['user_id'];
$agent_id = $_POST['agent_id'] ?? $_GET['agent_id'];

// Get or create conversation
$conv_stmt = $pdo->prepare("SELECT id FROM conversations WHERE user_id = ? AND agent_id = ? ORDER BY updated_at DESC LIMIT 1");
$conv_stmt->execute([$user_id, $agent_id]);
$conversation = $conv_stmt->fetch(PDO::FETCH_ASSOC);

$conversation_id = $conversation['id'] ?? null;
$messages = [];

if ($conversation_id) {
    $msg_stmt = $pdo->prepare("SELECT * FROM messages WHERE conversation_id = ? ORDER BY timestamp ASC");
    $msg_stmt->execute([$conversation_id]);
    $messages = $msg_stmt->fetchAll(PDO::FETCH_ASSOC);
}

echo json_encode([
    'conversation_id' => $conversation_id,
    'messages' => $messages
]);
?>