<?php
require_once '../auth.php';

if (!$auth->isLoggedIn()) {
    echo json_encode(['error' => 'Not authenticated']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user_id = $_SESSION['user_id'];
    $agent_id = $_POST['agent_id'];
    $name = $_POST['name'];
    $personality = $_POST['personality'];
    $age = $_POST['age'];
    $gender = $_POST['gender'];
    $location = $_POST['location'];
    $avatar = $_POST['avatar'] ?: 'https://randomuser.me/api/portraits/women/'.rand(1,99).'.jpg';
    
    if ($agent_id) {
        // Update existing agent
        $stmt = $pdo->prepare("UPDATE ai_agents SET name = ?, personality = ?, age = ?, gender = ?, location = ?, avatar = ? WHERE id = ? AND user_id = ?");
        $stmt->execute([$name, $personality, $age, $gender, $location, $avatar, $agent_id, $user_id]);
    } else {
        // Create new agent
        $stmt = $pdo->prepare("INSERT INTO ai_agents (user_id, name, personality, age, gender, location, avatar) VALUES (?, ?, ?, ?, ?, ?, ?)");
        $stmt->execute([$user_id, $name, $personality, $age, $gender, $location, $avatar]);
    }
    
    echo json_encode(['success' => true]);
}
?>