<?php
require_once '../auth.php';

if (!$auth->isLoggedIn()) {
    header('Content-Type: application/json');
    echo json_encode(['error' => 'Not authenticated']);
    exit;
}

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $user_id = $_SESSION['user_id'];
        $conversation_id = $_POST['conversation_id'] ?? null;
        $agent_id = $_POST['agent_id'];
        $role = $_POST['role'];
        $content = $_POST['content'];
        
        // Create conversation if it doesn't exist
        if (!$conversation_id) {
            $title = substr($content, 0, 50) . (strlen($content) > 50 ? '...' : '');
            $conv_stmt = $pdo->prepare("INSERT INTO conversations (user_id, agent_id, title) VALUES (?, ?, ?)");
            $conv_stmt->execute([$user_id, $agent_id, $title]);
            $conversation_id = $pdo->lastInsertId();
        }
        
        // Save message
        $msg_stmt = $pdo->prepare("INSERT INTO messages (conversation_id, role, content) VALUES (?, ?, ?)");
        $msg_stmt->execute([$conversation_id, $role, $content]);
        
        echo json_encode([
            'success' => true, 
            'conversation_id' => $conversation_id
        ]);
    } catch (Exception $e) {
        error_log("Error in save_message.php: " . $e->getMessage());
        echo json_encode(['error' => 'Failed to save message']);
    }
}
?>