<?php
require_once '../auth.php';

if (!$auth->isLoggedIn()) {
    echo json_encode(['error' => 'Not authenticated']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user_id = $_SESSION['user_id'];
    $setting_key = $_POST['setting_key'];
    $setting_value = $_POST['setting_value'];
    
    // Convert boolean values
    if ($setting_value === 'true') $setting_value = 1;
    if ($setting_value === 'false') $setting_value = 0;
    
    $stmt = $pdo->prepare("UPDATE user_settings SET $setting_key = ? WHERE user_id = ?");
    $stmt->execute([$setting_value, $user_id]);
    
    echo json_encode(['success' => true]);
}
?>