<?php
require_once '../auth.php';

if (!$auth->isLoggedIn()) {
    header('Content-Type: application/json');
    echo json_encode(['error' => 'Not authenticated']);
    exit;
}

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $user_id = $_SESSION['user_id'];
        $agent_id = $_POST['agent_id'];
        
        // Verify the agent belongs to the user
        $stmt = $pdo->prepare("SELECT * FROM ai_agents WHERE id = ? AND user_id = ?");
        $stmt->execute([$agent_id, $user_id]);
        $agent = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($agent) {
            echo json_encode([
                'success' => true,
                'agent' => $agent
            ]);
        } else {
            echo json_encode(['error' => 'Agent not found']);
        }
    } catch (Exception $e) {
        error_log("Error in switch_agent.php: " . $e->getMessage());
        echo json_encode(['error' => 'Failed to switch agent']);
    }
}
?>