<?php
require_once '../auth.php';

if (!$auth->isLoggedIn()) {
    echo json_encode(['error' => 'Not authenticated']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user_id = $_SESSION['user_id'];
    $name = $_POST['name'];
    $gender = $_POST['gender'];
    $bio = $_POST['bio'];
    $avatar = $_POST['avatar'];
    
    $stmt = $pdo->prepare("UPDATE users SET name = ?, gender = ?, bio = ?, avatar = ? WHERE id = ?");
    if ($stmt->execute([$name, $gender, $bio, $avatar, $user_id])) {
        // Update session
        $_SESSION['name'] = $name;
        $_SESSION['gender'] = $gender;
        $_SESSION['bio'] = $bio;
        $_SESSION['avatar'] = $avatar;
        
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['error' => 'Failed to update profile']);
    }
}
?>