<?php
// Database configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'fuzesale_qpal');
define('DB_USER', 'fuzesale_qpal');
define('DB_PASS', '!!!###1985ENi!!!');

// Session configuration
session_start();

// Create database connection
try {
    $pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch(PDOException $e) {
    die("Connection failed: " . $e->getMessage());
}

// Create tables if they don't exist
function createTables($pdo) {
    // Users table
    $users_table = "CREATE TABLE IF NOT EXISTS users (
        id INT AUTO_INCREMENT PRIMARY KEY,
        username VARCHAR(50) UNIQUE NOT NULL,
        email VARCHAR(100) UNIQUE NOT NULL,
        password VARCHAR(255) NOT NULL,
        name VARCHAR(100) NOT NULL,
        gender ENUM('male', 'female', 'other') DEFAULT 'male',
        bio TEXT,
        avatar TEXT,
        vine_access_key VARCHAR(100) DEFAULT NULL,
        is_admin BOOLEAN DEFAULT FALSE,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    )";
    
    // AI Agents table
    $agents_table = "CREATE TABLE IF NOT EXISTS ai_agents (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT NOT NULL,
        name VARCHAR(100) NOT NULL,
        avatar TEXT,
        age VARCHAR(50),
        gender ENUM('male', 'female', 'other') DEFAULT 'female',
        location VARCHAR(100),
        personality TEXT,
        is_default BOOLEAN DEFAULT FALSE,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
    )";
    
    // Conversations table
    $conversations_table = "CREATE TABLE IF NOT EXISTS conversations (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT NOT NULL,
        agent_id INT NOT NULL,
        title VARCHAR(255),
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
        FOREIGN KEY (agent_id) REFERENCES ai_agents(id) ON DELETE CASCADE
    )";
    
    // Messages table
    $messages_table = "CREATE TABLE IF NOT EXISTS messages (
        id INT AUTO_INCREMENT PRIMARY KEY,
        conversation_id INT NOT NULL,
        role ENUM('user', 'agent') NOT NULL,
        content TEXT NOT NULL,
        files TEXT,
        timestamp TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (conversation_id) REFERENCES conversations(id) ON DELETE CASCADE
    )";
    
    // User settings table
    $settings_table = "CREATE TABLE IF NOT EXISTS user_settings (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT NOT NULL,
        theme VARCHAR(50) DEFAULT 'cyberpunk',
        sentience_level INT DEFAULT 3,
        emotional_depth INT DEFAULT 3,
        creativity_level INT DEFAULT 3,
        memory_capacity INT DEFAULT 3,
        internet_access BOOLEAN DEFAULT TRUE,
        real_time_data BOOLEAN DEFAULT TRUE,
        multilingual BOOLEAN DEFAULT TRUE,
        technical_knowledge BOOLEAN DEFAULT TRUE,
        creative_writing BOOLEAN DEFAULT TRUE,
        analytical_skills BOOLEAN DEFAULT TRUE,
        response_speed VARCHAR(20) DEFAULT 'normal',
        verbosity VARCHAR(20) DEFAULT 'balanced',
        humor_level INT DEFAULT 2,
        formality_level INT DEFAULT 3,
        empathy_level INT DEFAULT 3,
        opinion_strength INT DEFAULT 3,
        adaptability INT DEFAULT 3,
        sarcasm_level INT DEFAULT 2,
        storytelling INT DEFAULT 3,
        flirtatiousness INT DEFAULT 0,
        mystery_level INT DEFAULT 2,
        wisdom_level INT DEFAULT 3,
        romantic_level INT DEFAULT 0,
        rebelliousness INT DEFAULT 2,
        spirituality INT DEFAULT 0,
        intellectual_level INT DEFAULT 3,
        sensitivity INT DEFAULT 3,
        confidence_level INT DEFAULT 3,
        extroversion INT DEFAULT 3,
        optimism_level INT DEFAULT 3,
        FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
    )";
    
    try {
        $pdo->exec($users_table);
        $pdo->exec($agents_table);
        $pdo->exec($conversations_table);
        $pdo->exec($messages_table);
        $pdo->exec($settings_table);
        
        // Create default admin user if not exists
        $admin_check = $pdo->prepare("SELECT id FROM users WHERE username = 'admin'");
        $admin_check->execute();
        
        if ($admin_check->rowCount() == 0) {
            $admin_password = password_hash('admin123', PASSWORD_DEFAULT);
            $admin_stmt = $pdo->prepare("INSERT INTO users (username, email, password, name, is_admin) VALUES (?, ?, ?, ?, ?)");
            $admin_stmt->execute(['admin', 'admin@vinesubtech.com.ng', $admin_password, 'Administrator', true]);
        }
    } catch(PDOException $e) {
        error_log("Table creation error: " . $e->getMessage());
    }
}

// Initialize tables
createTables($pdo);
?>