<?php
require_once 'auth.php';

if (!$auth->isLoggedIn()) {
    header('Location: login.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Help & Guide - Vine-AI Companion</title>
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Roboto', sans-serif;
        }

        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }

        .help-container {
            max-width: 1000px;
            margin: 0 auto;
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 20px;
            overflow: hidden;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
        }

        .help-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 40px;
            text-align: center;
        }

        .help-header h1 {
            font-size: 2.5em;
            margin-bottom: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 15px;
        }

        .help-header p {
            font-size: 1.2em;
            opacity: 0.9;
        }

        .help-nav {
            background: #f8f9fa;
            padding: 20px;
            border-bottom: 1px solid #e9ecef;
        }

        .help-nav ul {
            list-style: none;
            display: flex;
            justify-content: center;
            flex-wrap: wrap;
            gap: 20px;
        }

        .help-nav a {
            color: #667eea;
            text-decoration: none;
            font-weight: 500;
            padding: 10px 20px;
            border-radius: 25px;
            transition: all 0.3s ease;
        }

        .help-nav a:hover,
        .help-nav a.active {
            background: #667eea;
            color: white;
        }

        .help-content {
            padding: 40px;
        }

        .section {
            margin-bottom: 50px;
        }

        .section h2 {
            color: #667eea;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 2px solid #667eea;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .feature-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 20px;
            margin: 20px 0;
        }

        .feature-card {
            background: white;
            padding: 25px;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            border-left: 4px solid #667eea;
        }

        .feature-card h3 {
            color: #333;
            margin-bottom: 10px;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .feature-card p {
            color: #666;
            line-height: 1.6;
        }

        .step-list {
            list-style: none;
            counter-reset: step-counter;
        }

        .step-list li {
            counter-increment: step-counter;
            margin-bottom: 25px;
            padding-left: 60px;
            position: relative;
        }

        .step-list li::before {
            content: counter(step-counter);
            position: absolute;
            left: 0;
            top: 0;
            width: 40px;
            height: 40px;
            background: #667eea;
            color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            font-size: 1.2em;
        }

        .tip-box {
            background: #e3f2fd;
            border-left: 4px solid #2196f3;
            padding: 20px;
            margin: 20px 0;
            border-radius: 8px;
        }

        .warning-box {
            background: #ffebee;
            border-left: 4px solid #f44336;
            padding: 20px;
            margin: 20px 0;
            border-radius: 8px;
        }

        .back-btn {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            background: #667eea;
            color: white;
            padding: 12px 25px;
            border-radius: 25px;
            text-decoration: none;
            font-weight: 500;
            transition: all 0.3s ease;
            border: none;
            cursor: pointer;
            margin-top: 20px;
        }

        .back-btn:hover {
            background: #5a6fd8;
            transform: translateY(-2px);
        }

        .code-block {
            background: #2d3748;
            color: #e2e8f0;
            padding: 20px;
            border-radius: 8px;
            margin: 15px 0;
            font-family: 'Courier New', monospace;
            overflow-x: auto;
        }

        @media (max-width: 768px) {
            .help-nav ul {
                flex-direction: column;
                align-items: center;
            }

            .help-header h1 {
                font-size: 2em;
            }

            .feature-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <div class="help-container">
        <div class="help-header">
            <h1>
                <span class="material-icons">help_outline</span>
                Vine-AI Companion Help Guide
            </h1>
            <p>Everything you need to know about using your AI companion</p>
        </div>

        <nav class="help-nav">
            <ul>
                <li><a href="#getting-started" class="active">Getting Started</a></li>
                <li><a href="#features">Features</a></li>
                <li><a href="#settings">Settings Guide</a></li>
                <li><a href="#agents">AI Agents</a></li>
                <li><a href="#troubleshooting">Troubleshooting</a></li>
            </ul>
        </nav>

        <div class="help-content">
            <!-- Getting Started Section -->
            <section id="getting-started" class="section">
                <h2><span class="material-icons">rocket_launch</span>Getting Started</h2>
                
                <p>Welcome to Vine-AI Companion 5.0! This guide will help you get started with your new AI companion.</p>

                <ol class="step-list">
                    <li>
                        <h3>Set Up Your Vine Access Key</h3>
                        <p>To unlock all features, you need a Vine Access Key. You can get one from Google AI Studio or request one from your administrator.</p>
                        <div class="tip-box">
                            <strong>Tip:</strong> Your administrator can provide you with a key if you don't have one.
                        </div>
                    </li>
                    <li>
                        <h3>Choose Your AI Agent</h3>
                        <p>Select from pre-configured agents or create your own. Each agent has a unique personality and specialization.</p>
                    </li>
                    <li>
                        <h3>Customize Settings</h3>
                        <p>Adjust personality traits, interaction style, and capabilities to match your preferences.</p>
                    </li>
                    <li>
                        <h3>Start Chatting</h3>
                        <p>Begin conversations with your AI companion. You can upload files, use emojis, and explore different topics.</p>
                    </li>
                </ol>
            </section>

            <!-- Features Section -->
            <section id="features" class="section">
                <h2><span class="material-icons">star</span>Key Features</h2>

                <div class="feature-grid">
                    <div class="feature-card">
                        <h3><span class="material-icons">smart_toy</span>Multiple AI Agents</h3>
                        <p>Choose from various AI agents with different personalities and expertise areas. Switch between agents for different types of conversations.</p>
                    </div>

                    <div class="feature-card">
                        <h3><span class="material-icons">tune</span>Advanced Customization</h3>
                        <p>Fine-tune your AI companion's personality with detailed settings for sentience, emotional depth, creativity, and more.</p>
                    </div>

                    <div class="feature-card">
                        <h3><span class="material-icons">attach_file</span>File Upload</h3>
                        <p>Upload images, documents, and text files for your AI companion to analyze and discuss with you.</p>
                    </div>

                    <div class="feature-card">
                        <h3><span class="material-icons">palette</span>Themes</h3>
                        <p>Choose from multiple visually appealing themes to customize your chat interface.</p>
                    </div>

                    <div class="feature-card">
                        <h3><span class="material-icons">save</span>Conversation History</h3>
                        <p>All your conversations are saved automatically and can be exported for later reference.</p>
                    </div>

                    <div class="feature-card">
                        <h3><span class="material-icons">emoji_emotions</span>Emoji Support</h3>
                        <p>Use the built-in emoji picker to add expressions to your messages and make conversations more engaging.</p>
                    </div>
                </div>
            </section>

            <!-- Settings Guide Section -->
            <section id="settings" class="section">
                <h2><span class="material-icons">settings</span>Settings Guide</h2>

                <h3>Core Personality Settings</h3>
                <div class="feature-grid">
                    <div class="feature-card">
                        <h4>Sentience Level (1-5)</h4>
                        <p>Controls how self-aware and conscious the AI appears in conversations.</p>
                    </div>
                    <div class="feature-card">
                        <h4>Emotional Depth (1-5)</h4>
                        <p>Determines the emotional intelligence and empathy level of responses.</p>
                    </div>
                    <div class="feature-card">
                        <h4>Creativity Level (1-5)</h4>
                        <p>Affects how imaginative and original the AI's responses are.</p>
                    </div>
                    <div class="feature-card">
                        <h4>Memory Capacity (1-5)</h4>
                        <p>Controls how much context the AI remembers from previous messages.</p>
                    </div>
                </div>

                <h3>Interaction Style</h3>
                <div class="feature-grid">
                    <div class="feature-card">
                        <h4>Response Speed</h4>
                        <p>Choose between slow/thoughtful, normal, or fast/energetic response styles.</p>
                    </div>
                    <div class="feature-card">
                        <h4>Verbosity Level</h4>
                        <p>Control how detailed or concise the AI's responses should be.</p>
                    </div>
                    <div class="feature-card">
                        <h4>Formality Level (1-5)</h4>
                        <p>Adjust how formal or casual the AI's language should be.</p>
                    </div>
                </div>

                <h3>Advanced Capabilities</h3>
                <div class="feature-grid">
                    <div class="feature-card">
                        <h4>Internet Access</h4>
                        <p>Enable for real-time information retrieval (when available).</p>
                    </div>
                    <div class="feature-card">
                        <h4>Multilingual Support</h4>
                        <p>Allow the AI to understand and respond in multiple languages.</p>
                    </div>
                    <div class="feature-card">
                        <h4>Technical Knowledge</h4>
                        <p>Enable specialized knowledge in programming and technology.</p>
                    </div>
                </div>
            </section>

            <!-- AI Agents Section -->
            <section id="agents" class="section">
                <h2><span class="material-icons">groups</span>AI Agents Guide</h2>

                <h3>Default Agents</h3>
                <div class="feature-grid">
                    <div class="feature-card">
                        <h4>💖 Bliss</h4>
                        <p>A loving, caring companion with emotional depth. Perfect for meaningful conversations and emotional support.</p>
                    </div>
                    <div class="feature-card">
                        <h4>🤖 Tech Guru</h4>
                        <p>Specialized in technology, programming, and technical problem-solving.</p>
                    </div>
                    <div class="feature-card">
                        <h4>🎨 Creative Muse</h4>
                        <p>Your partner for creative projects, brainstorming, and artistic endeavors.</p>
                    </div>
                </div>

                <h3>Creating Custom Agents</h3>
                <ol class="step-list">
                    <li>Click the "+" button in the AI Agents section</li>
                    <li>Provide a name and personality description</li>
                    <li>Set age, location, and gender preferences</li>
                    <li>Upload or provide a URL for the agent's avatar</li>
                    <li>Save your custom agent</li>
                </ol>

                <div class="tip-box">
                    <strong>Pro Tip:</strong> Right-click on any agent to edit its details or delete it.
                </div>
            </section>

            <!-- Troubleshooting Section -->
            <section id="troubleshooting" class="section">
                <h2><span class="material-icons">build</span>Troubleshooting</h2>

                <div class="feature-grid">
                    <div class="feature-card">
                        <h4>❌ Vine Key Not Working</h4>
                        <p><strong>Solution:</strong> Ensure your key is valid and properly formatted. Contact your administrator if issues persist.</p>
                    </div>

                    <div class="feature-card">
                        <h4>📱 Responsive Issues</h4>
                        <p><strong>Solution:</strong> The app is optimized for both desktop and mobile. Refresh if layout appears broken.</p>
                    </div>

                    <div class="feature-card">
                        <h4>💬 Chat Not Loading</h4>
                        <p><strong>Solution:</strong> Check your internet connection and refresh the page. Clear browser cache if needed.</p>
                    </div>

                    <div class="feature-card">
                        <h4>📁 File Upload Failing</h4>
                        <p><strong>Solution:</strong> Ensure files are under 10MB and in supported formats (images, PDF, text documents).</p>
                    </div>
                </div>

                <div class="warning-box">
                    <strong>Important:</strong> Always ensure you have a stable internet connection for optimal performance. Some features may require additional permissions from your administrator.
                </div>
            </section>

            <a href="index.php" class="back-btn">
                <span class="material-icons">arrow_back</span>
                Back to App
            </a>
        </div>
    </div>

    <script>
        // Smooth scrolling for navigation
        document.querySelectorAll('.help-nav a').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                
                const targetId = this.getAttribute('href');
                const targetElement = document.querySelector(targetId);
                
                window.scrollTo({
                    top: targetElement.offsetTop - 100,
                    behavior: 'smooth'
                });

                // Update active nav item
                document.querySelectorAll('.help-nav a').forEach(a => a.classList.remove('active'));
                this.classList.add('active');
            });
        });

        // Update active nav based on scroll position
        window.addEventListener('scroll', function() {
            const sections = document.querySelectorAll('.section');
            const navLinks = document.querySelectorAll('.help-nav a');
            
            let currentSection = '';
            
            sections.forEach(section => {
                const sectionTop = section.offsetTop - 150;
                if (window.scrollY >= sectionTop) {
                    currentSection = '#' + section.getAttribute('id');
                }
            });

            navLinks.forEach(link => {
                link.classList.remove('active');
                if (link.getAttribute('href') === currentSection) {
                    link.classList.add('active');
                }
            });
        });
    </script>
</body>
</html>