<?php
require_once 'auth.php';

if (!$auth->isLoggedIn()) {
    header('Location: login.php');
    exit;
}
?>
<!-- Profile Modal -->
<div class="modal" id="profileModal">
    <div class="modal-content">
        <div class="modal-header">
            <h3><span class="material-icons">person</span>Edit Profile</h3>
            <button class="close-modal" id="closeProfileModal">&times;</button>
        </div>
        <div class="modal-body">
            <form id="profileForm">
                <div class="form-group">
                    <label for="editName">Full Name</label>
                    <input type="text" id="editName" name="name" value="<?php echo htmlspecialchars($_SESSION['name']); ?>" required>
                </div>
                <div class="form-group">
                    <label for="editGender">Gender</label>
                    <select id="editGender" name="gender">
                        <option value="male" <?php echo ($_SESSION['gender'] ?? 'male') === 'male' ? 'selected' : ''; ?>>Male</option>
                        <option value="female" <?php echo ($_SESSION['gender'] ?? 'male') === 'female' ? 'selected' : ''; ?>>Female</option>
                        <option value="other" <?php echo ($_SESSION['gender'] ?? 'male') === 'other' ? 'selected' : ''; ?>>Other</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="editBio">Bio</label>
                    <textarea id="editBio" name="bio" placeholder="Tell us about yourself"><?php echo htmlspecialchars($_SESSION['bio'] ?? 'AI Companion User'); ?></textarea>
                </div>
                <div class="form-group">
                    <label for="editAvatar">Avatar URL</label>
                    <input type="text" id="editAvatar" name="avatar" placeholder="Enter image URL" value="<?php echo htmlspecialchars($_SESSION['avatar'] ?? ''); ?>">
                </div>
            </form>
        </div>
        <div class="modal-footer">
            <button class="btn btn-secondary" id="cancelProfileBtn">Cancel</button>
            <button class="btn btn-primary" id="saveProfileBtn">Save Changes</button>
        </div>
    </div>
</div>

<!-- Agent Modal -->
<div class="modal" id="agentModal">
    <div class="modal-content">
        <div class="modal-header">
            <h3 id="agentModalTitle"><span class="material-icons">smart_toy</span>New AI Agent</h3>
            <button class="close-modal" id="closeAgentModal">&times;</button>
        </div>
        <div class="modal-body">
            <form id="agentForm">
                <div class="form-group">
                    <label for="agentName">Agent Name</label>
                    <input type="text" id="agentName" name="name" placeholder="Enter agent name" required>
                </div>
                <div class="form-group">
                    <label for="agentPersonality">Personality Description</label>
                    <textarea id="agentPersonality" name="personality" placeholder="Describe the agent's personality, behavior, and characteristics" required></textarea>
                </div>
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                    <div class="form-group">
                        <label for="agentAge">Age</label>
                        <input type="text" id="agentAge" name="age" placeholder="e.g., Ageless, 25, Unknown">
                    </div>
                    <div class="form-group">
                        <label for="agentGender">Gender</label>
                        <select id="agentGender" name="gender">
                            <option value="female">Female</option>
                            <option value="male">Male</option>
                            <option value="other">Other</option>
                        </select>
                    </div>
                </div>
                <div class="form-group">
                    <label for="agentLocation">Location</label>
                    <input type="text" id="agentLocation" name="location" placeholder="e.g., NYC, Virtual Space, Internet">
                </div>
                <div class="form-group">
                    <label for="agentAvatar">Avatar URL</label>
                    <input type="text" id="agentAvatar" name="avatar" placeholder="https://example.com/avatar.jpg">
                </div>
                <input type="hidden" id="editAgentId" name="agent_id">
            </form>
        </div>
        <div class="modal-footer">
            <button class="btn btn-danger" id="deleteAgentBtn" style="display: none; margin-right: auto;">Delete Agent</button>
            <button class="btn btn-secondary" id="cancelAgentBtn">Cancel</button>
            <button class="btn btn-primary" id="saveAgentBtn">Save Agent</button>
        </div>
    </div>
</div>

<!-- API Key Modal -->
<div class="modal" id="apiKeyModal">
    <div class="modal-content small">
        <div class="modal-header">
            <h3><span class="material-icons">vpn_key</span>VINE ACCESS Key Required</h3>
            <button class="close-modal" id="closeApiKeyModal">&times;</button>
        </div>
        <div class="modal-body">
            <div class="form-group">
                <label for="apiKeyInputModal">Enter your VINE Access Key</label>
                <input type="password" id="apiKeyInputModal" placeholder="Enter your Vine Access Key">
                <p class="api-key-status" id="apiKeyStatusModal"></p>
                <p style="font-size: 12px; color: var(--secondary-color); margin-top: 8px;">
                    Your key should start with "AIzaSy" and be 39 characters long.
                </p>
            </div>
        </div>
        <div class="modal-footer" style="display: flex; gap: 10px;">
            <button class="btn btn-secondary" id="cancelApiKeyBtn">Cancel</button>
            <button class="btn btn-primary" id="saveApiKeyBtn">Save Key</button>
            <button class="btn" id="buyApiKeyBtn" onclick="window.open('https://aistudio.google.com/', '_blank')" style="background: var(--success-color);">Get Key</button>
        </div>
    </div>
</div>

<!-- Confirm Modal -->
<div class="modal" id="confirmModal">
    <div class="modal-content small">
        <div class="modal-header">
            <h3><span class="material-icons">warning</span>Confirm Action</h3>
            <button class="close-modal" id="closeConfirmModal">&times;</button>
        </div>
        <div class="modal-body">
            <p id="confirmMessage">Are you sure you want to perform this action? This cannot be undone.</p>
        </div>
        <div class="modal-footer">
            <button class="btn btn-secondary" id="cancelConfirmBtn">Cancel</button>
            <button class="btn btn-danger" id="confirmActionBtn">Confirm</button>
        </div>
    </div>
</div>

<!-- Key Assigned Notification -->
<div class="modal" id="keyAssignedModal">
    <div class="modal-content small">
        <div class="modal-header">
            <h3><span class="material-icons">vpn_key</span>VINE Key Activated!</h3>
            <button class="close-modal" id="closeKeyAssignedModal">&times;</button>
        </div>
        <div class="modal-body">
            <p>Your VINE Access Key has been successfully activated! You can now use all features of the Vine-AI Companion.</p>
            <div style="background: var(--setting-section-bg); padding: 10px; border-radius: 5px; margin-top: 10px;">
                <strong>Status:</strong> <span style="color: var(--success-color);">✅ Active</span>
            </div>
        </div>
        <div class="modal-footer">
            <button class="btn btn-primary" id="closeKeyAssignedBtn">Start Chatting</button>
        </div>
    </div>
</div>