<?php
// id_card.php
session_start();

// Initialize JSON file if it doesn't exist
if (!file_exists('data/students.json')) {
    file_put_contents('data/students.json', json_encode([]));
}

$students = json_decode(file_get_contents('data/students.json'), true);
$student = null;

// Get student data for ID card
if (isset($_GET['prime_id'])) {
    $primeId = $_GET['prime_id'];
    foreach ($students as $s) {
        if ($s['prime_id'] === $primeId) {
            $student = $s;
            break;
        }
    }
}

// If student not found, redirect
if (!$student) {
    $_SESSION['error'] = "Student record not found!";
    header('Location: index.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Student ID Card - <?= $student['prime_id'] ?></title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@mdi/font@7.2.96/css/materialdesignicons.min.css">
    <style>
        body {
            background-color: #f0f2f5;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .id-card {
            width: 350px;
            height: 512px;
            background: linear-gradient(135deg, #1a2a6c, #b21f1f, #fdbb2d);
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
            overflow: hidden;
            position: relative;
            color: white;
            margin: 20px auto;
        }
        .id-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('assets/watermark.png') center/contain no-repeat;
            opacity: 0.1;
            z-index: 1;
        }
        .id-content {
            position: relative;
            z-index: 2;
            padding: 20px;
            height: 100%;
            display: flex;
            flex-direction: column;
        }
        .id-header {
            text-align: center;
            margin-bottom: 15px;
            border-bottom: 2px solid rgba(255, 255, 255, 0.3);
            padding-bottom: 10px;
        }
        .school-logo {
            width: 80px;
            height: 80px;
            margin: 0 auto 10px;
            background-color: white;
            border-radius: 50%;
            padding: 5px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .school-logo img {
            max-width: 100%;
            max-height: 100%;
        }
        .id-body {
            display: flex;
            flex-grow: 1;
            margin: 10px 0;
        }
        .id-photo-section {
            flex: 0 0 40%;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: flex-start;
            padding-right: 15px;
            border-right: 1px solid rgba(255, 255, 255, 0.3);
        }
        .id-photo {
            width: 120px;
            height: 140px;
            border: 3px solid white;
            border-radius: 5px;
            overflow: hidden;
            background-color: #f8f9fa;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            margin-bottom: 15px;
        }
        .id-photo img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        .id-details-section {
            flex: 0 0 60%;
            padding-left: 15px;
            display: flex;
            flex-direction: column;
            justify-content: center;
        }
        .student-name {
            font-size: 16px;
            font-weight: bold;
            margin-bottom: 3px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            text-align: center;
        }
        .student-id {
            font-size: 14px;
            margin-bottom: 15px;
            text-align: center;
            font-weight: 500;
            background: rgba(0, 0, 0, 0.2);
            padding: 3px 8px;
            border-radius: 4px;
        }
        .id-detail-item {
            margin-bottom: 6px;
            display: flex;
            align-items: center;
            font-size: 13px;
        }
        .id-detail-item .mdi {
            margin-right: 6px;
            font-size: 15px;
            flex-shrink: 0;
            width: 20px;
            text-align: center;
        }
        .id-footer {
            text-align: center;
            margin-top: 6px;
            padding-top: 6px;
            border-top: 2px solid rgba(255, 255, 255, 0.3);
            font-size: 10px;
        }
        .id-footer p {
            margin-bottom: 3px;
            line-height: 1.3;
        }
        .action-buttons {
            margin-top: 20px;
            text-align: center;
        }
        .signature-area {
            margin-top: 6px;
            padding-top: 5px;
            border-top: 1px dashed rgba(255, 255, 255, 0.3);
            text-align: center;
            font-size: 10px;
        }
        
        @media print {
            body {
                background-color: white;
            }
            .action-buttons {
                display: none;
            }
            .id-card {
                box-shadow: none;
                margin: 0;
            }
        }
    </style>
</head>
<body>
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-md-8 text-center mb-4">
                <h1 class="text-primary"><i class="mdi mdi-card-account-details"></i> Student ID Card</h1>
                <p class="lead">Official identification for <?= $student['surname'] . ' ' . $student['other_names'] ?></p>
            </div>
        </div>
        
        <div class="row justify-content-center">
            <div class="col-md-12 text-center">
                <!-- ID Card -->
                <div class="id-card">
                    <div class="id-content">
                        <div class="id-header">
                            <div class="school-logo">
                                <img src="assets/logo.png" alt="School Logo">
                            </div>
                            <h4 class="mb-0" style="font-size: 18px;">PRIME GATEWAY ACADEMY</h4>
                            <p class="mb-0" style="font-size: 12px;">OFFICIAL STUDENT IDENTIFICATION</p>
                        </div>
                        
                        <div class="id-body">
                            <div class="id-photo-section">
                                <div class="id-photo">
                                    <?php if (isset($student['photo']) && file_exists('uploads/' . $student['photo'])): ?>
                                        <img src="uploads/<?= $student['photo'] ?>" alt="Student Photo">
                                    <?php else: ?>
                                        <div class="d-flex align-items-center justify-content-center h-100 text-muted">
                                            <i class="mdi mdi-account-box-outline mdi-36px"></i>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="student-name"><?= $student['surname'] ?></div>
                                <div class="student-name" style="font-size: 16px; margin-bottom: 3px;"><?= $student['other_names'] ?></div>
                            </div>
                            
                            <div class="id-details-section">
                                <div class="student-id">PRIME ID: <?= $student['prime_id'] ?></div>
                                
                                <div class="id-detail-item">
                                    <i class="mdi mdi-gender-male-female"></i>
                                    <span>Sex: <?= $student['sex'] ?></span>
                                </div>
                                <div class="id-detail-item">
                                    <i class="mdi mdi-calendar"></i>
                                    <span>DOB: <?= date('M j, Y', strtotime($student['dob'])) ?></span>
                                </div>
                                <div class="id-detail-item">
                                    <i class="mdi mdi-phone"></i>
                                    <span>Tel: <?= $student['father_phone'] ?></span>
                                </div>
                                <div class="id-detail-item">
                                    <i class="mdi mdi-email"></i>
                                    <span><?= $student['parent_email'] ?: 'N/A' ?></span>
                                </div>
                                
                                <div class="signature-area">
                                    <div style="height: 20px; border-bottom: 1px solid rgba(255, 255, 255, 0.5); margin-bottom: 3px;"></div>
                                    <div>Authorized Signature</div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="id-footer">
                            <p class="mb-0">Agbaluku Arigidi Akoko,Ondo State, Nigeria</p>
                            <p class="mb-0">Phone: +(234) 7039615126 | Email: primegatewayacademy@gmail.com</p>
                            <p class="mb-0" style="margin-top: 5px;"><em>This card is the property of PRIME GATEWAY ACADEMY</em></p>
                            <p class="mb-0"><em>If found, please return to the address above</em></p>
                            <p class="mb-0" style="margin-top: 3px;"><strong>VALID FOR CURRENT ACADEMIC YEAR ONLY</strong></p>
                        </div>
                    </div>
                </div>
                
                <div class="action-buttons">
                    <button onclick="window.print()" class="btn btn-primary me-2">
                        <i class="mdi mdi-printer"></i> Print ID Card
                    </button>
                    <a href="index.php" class="btn btn-secondary">
                        <i class="mdi mdi-arrow-left"></i> Back to Home
                    </a>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>