<?php
// index.php
session_start();

// Initialize JSON file if it doesn't exist
if (!file_exists('data/students.json')) {
    file_put_contents('data/students.json', json_encode([]));
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $studentData = [
        'id' => uniqid('STU'),
        'surname' => $_POST['surname'],
        'other_names' => $_POST['other_names'],
        'sex' => $_POST['sex'],
        'dob' => $_POST['dob'],
        'religion' => $_POST['religion'],
        'father_phone' => $_POST['father_phone'],
        'mother_phone' => $_POST['mother_phone'] ?? '',
        'previous_class' => $_POST['previous_class'],
        'proposed_class' => $_POST['proposed_class'],
        'state_origin' => $_POST['state_origin'],
        'home_town' => $_POST['home_town'] ?? '',
        'parent_email' => $_POST['parent_email'] ?? '',
        'home_address' => $_POST['home_address'],
        'previous_school' => $_POST['previous_school'],
        'status' => $_POST['status'],
        'registration_date' => date('Y-m-d H:i:s')
    ];

    // Handle photo upload
    if (isset($_FILES['photo']) && $_FILES['photo']['error'] === UPLOAD_ERR_OK) {
        $uploadDir = 'uploads/';
        if (!file_exists($uploadDir)) {
            mkdir($uploadDir, 0777, true);
        }
        
        $fileExtension = pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION);
        $fileName = $studentData['id'] . '.' . $fileExtension;
        $uploadPath = $uploadDir . $fileName;
        
        if (move_uploaded_file($_FILES['photo']['tmp_name'], $uploadPath)) {
            $studentData['photo'] = $fileName;
        }
    }

    // Save to JSON
    $students = json_decode(file_get_contents('data/students.json'), true);
    $students[] = $studentData;
    file_put_contents('data/students.json', json_encode($students, JSON_PRETTY_PRINT));
    
    $_SESSION['success'] = "Student registered successfully! Student ID: " . $studentData['id'];
    header('Location: index.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Student Admission System</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@mdi/font@7.2.96/css/materialdesignicons.min.css">
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="card shadow">
                    <div class="card-header bg-primary text-white">
                        <h3 class="card-title"><i class="mdi mdi-account-plus"></i> Student Registration Form</h3>
                    </div>
                    <div class="card-body">
                        <?php if (isset($_SESSION['success'])): ?>
                            <div class="alert alert-success"><?= $_SESSION['success']; unset($_SESSION['success']); ?></div>
                        <?php endif; ?>
                        
                        <form method="POST" enctype="multipart/form-data" id="studentForm">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="surname" class="form-label">Surname <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" id="surname" name="surname" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="other_names" class="form-label">Other Names <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" id="other_names" name="other_names" required>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label for="sex" class="form-label">Sex <span class="text-danger">*</span></label>
                                        <select class="form-select" id="sex" name="sex" required>
                                            <option value="">Select Sex</option>
                                            <option value="Male">Male</option>
                                            <option value="Female">Female</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label for="dob" class="form-label">Date of Birth <span class="text-danger">*</span></label>
                                        <input type="date" class="form-control" id="dob" name="dob" required>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label for="religion" class="form-label">Religion <span class="text-danger">*</span></label>
                                        <select class="form-select" id="religion" name="religion" required>
                                            <option value="">Select Religion</option>
                                            <option value="Christianity">Christianity</option>
                                            <option value="Islam">Islam</option>
                                            <option value="Other">Other</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="father_phone" class="form-label">Father's Phone (11 digits) <span class="text-danger">*</span></label>
                                        <input type="tel" class="form-control" id="father_phone" name="father_phone" pattern="[0-9]{11}" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="mother_phone" class="form-label">Mother's Phone (11 digits)</label>
                                        <input type="tel" class="form-control" id="mother_phone" name="mother_phone" pattern="[0-9]{11}">
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="previous_class" class="form-label">Previous Class <span class="text-danger">*</span></label>
                                        <select class="form-select" id="previous_class" name="previous_class" required>
                                            <option value="">Select Previous Class</option>
                                            <option value="BG1">BG1</option>
                                            <option value="BG2">BG2</option>
                                            <option value="KG">KG</option>
                                            <option value="Nur1">Nur1</option>
                                            <option value="Nur2">Nur2</option>
                                            <option value="Pry1">Pry1</option>
                                            <option value="Pry2">Pry2</option>
                                            <option value="Pry3">Pry3</option>
                                            <option value="Pry4">Pry4</option>
                                            <option value="Pry5">Pry5</option>
                                            <option value="Pry6">Pry6</option>
                                            <option value="JSS1">JSS1</option>
                                            <option value="JSS2">JSS2</option>
                                            <option value="JSS3">JSS3</option>
                                            <option value="SSS1">SSS1</option>
                                            <option value="SSS2">SSS2</option>
                                            <option value="SSS3">SSS3</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="proposed_class" class="form-label">Proposed Class <span class="text-danger">*</span></label>
                                        <select class="form-select" id="proposed_class" name="proposed_class" required>
                                            <option value="">Select Proposed Class</option>
                                            <option value="BG1">BG1</option>
                                            <option value="BG2">BG2</option>
                                            <option value="KG">KG</option>
                                            <option value="Nur1">Nur1</option>
                                            <option value="Nur2">Nur2</option>
                                            <option value="Pry1">Pry1</option>
                                            <option value="Pry2">Pry2</option>
                                            <option value="Pry3">Pry3</option>
                                            <option value="Pry4">Pry4</option>
                                            <option value="Pry5">Pry5</option>
                                            <option value="Pry6">Pry6</option>
                                            <option value="JSS1">JSS1</option>
                                            <option value="JSS2">JSS2</option>
                                            <option value="JSS3">JSS3</option>
                                            <option value="SSS1">SSS1</option>
                                            <option value="SSS2">SSS2</option>
                                            <option value="SSS3">SSS3</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="state_origin" class="form-label">State of Origin <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" id="state_origin" name="state_origin" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="home_town" class="form-label">Home Town</label>
                                        <input type="text" class="form-control" id="home_town" name="home_town">
                                    </div>
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <label for="parent_email" class="form-label">Parent Email</label>
                                <input type="email" class="form-control" id="parent_email" name="parent_email">
                            </div>
                            
                            <div class="mb-3">
                                <label for="home_address" class="form-label">Home Address <span class="text-danger">*</span></label>
                                <textarea class="form-control" id="home_address" name="home_address" rows="3" required></textarea>
                            </div>
                            
                            <div class="mb-3">
                                <label for="previous_school" class="form-label">Previous School Attended <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="previous_school" name="previous_school" required>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="photo" class="form-label">Photo <span class="text-danger">*</span></label>
                                        <input type="file" class="form-control" id="photo" name="photo" accept="image/*" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
                                        <select class="form-select" id="status" name="status" required>
                                            <option value="">Select Status</option>
                                            <option value="qualified">Qualified</option>
                                            <option value="disqualified">Disqualified</option>
                                            <option value="probation">Probation</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="d-grid gap-2">
                                <button type="submit" class="btn btn-primary btn-lg"><i class="mdi mdi-content-save"></i> Register Student</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <?php include 'includes/footer.php'; ?>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/qrcode@1.5.1/build/qrcode.min.js"></script>
    <script src="js/script.js"></script>
</body>
</html>