# Uncensored AI Writer - Setup Instructions

## Project Overview
A sophisticated AI content generation platform built with PHP, MySQL, and Google Gemini API, designed to create human-like content that bypasses AI detection.

## Requirements
- PHP 7.4 or higher
- MySQL 5.7 or higher
- Web server (Apache/Nginx)
- SSL Certificate (recommended)

## Installation

1. **Upload Files**
   - Upload all PHP files to your web server
   - Ensure proper file permissions (644 for files, 755 for directories)

2. **Database Setup**
   - Create a MySQL database named `fuzesale_unaiw`
   - Import the provided SQL file: `fuzesale_unaiw.sql`
   - Update database credentials in `config.php` if different from default

3. **Configuration**
   - The default admin account will be created automatically:
     - Username: `aiadmin`
     - Password: `Eni23!ht`
   - Update payment gateway keys in `config.php` for production use

4. **API Configuration**
   - Users need to provide their Google Gemini API key suffix
   - The prefix "AIzaSy" is hardcoded in the application
   - Users enter only the remaining part of their API key

## Key Features

### Content Generation
- Advanced prompt engineering for human-like content
- Real-time streaming responses
- Multiple content types and tones
- SEO optimization built-in

### User Management
- Secure authentication system
- Article saving and management
- Custom AI agent creation
- API key management

### Payment Integration
- Flutterwave payment gateway
- Donation/tip system for developer support
- Transaction logging

## Security Features
- Prepared statements for SQL queries
- Password hashing
- Session management
- Input validation
- XSS protection

## File Structure