<?php
require_once 'config.php';
require_once 'auth.php';

header('Content-Type: application/json');

$auth = new Auth();
if (!$auth->isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Not authenticated']);
    exit;
}

if ($_POST && isset($_POST['action']) && $_POST['action'] === 'generate_content') {
    $prompt = $_POST['prompt'] ?? '';
    $apiKey = $_SESSION['api_key'] ?? '';
    
    if (!$apiKey) {
        echo json_encode(['success' => false, 'message' => 'API key not configured']);
        exit;
    }
    
    if (!$prompt) {
        echo json_encode(['success' => false, 'message' => 'No prompt provided']);
        exit;
    }
    
    try {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, GEMINI_API_BASE . '?key=' . $apiKey);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([
            'contents' => [
                [
                    'parts' => [
                        ['text' => $prompt]
                    ]
                ]
            ],
            'generationConfig' => [
                'temperature' => 0.7,
                'topK' => 40,
                'topP' => 0.95,
                'maxOutputTokens' => 8192,
            ]
        ]));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json'
        ]);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($httpCode !== 200) {
            throw new Exception('API request failed with code: ' . $httpCode);
        }
        
        $data = json_decode($response, true);
        
        if (isset($data['candidates'][0]['content']['parts'][0]['text'])) {
            $content = $data['candidates'][0]['content']['parts'][0]['text'];
            echo json_encode(['success' => true, 'content' => $content]);
        } else {
            throw new Exception('Invalid API response format');
        }
        
    } catch (Exception $e) {
        echo json_encode(['success' => false, 'message' => $e->getMessage()]);
    }
    
    exit;
}
?>