<?php
require_once 'auth.php';
require_once 'config.php';

$auth = new Auth();

if (!$auth->isLoggedIn()) {
    header('HTTP/1.1 401 Unauthorized');
    echo json_encode(['error' => 'Not authenticated']);
    exit;
}

if (!isset($_GET['id'])) {
    header('HTTP/1.1 400 Bad Request');
    echo json_encode(['error' => 'Article ID required']);
    exit;
}

$articleId = intval($_GET['id']);
$userId = $_SESSION['user_id'];

$pdo = getDBConnection();
$stmt = $pdo->prepare("SELECT * FROM articles WHERE id = ? AND user_id = ?");
$stmt->execute([$articleId, $userId]);
$article = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$article) {
    header('HTTP/1.1 404 Not Found');
    echo json_encode(['error' => 'Article not found']);
    exit;
}

header('Content-Type: application/json');
echo json_encode([
    'id' => $article['id'],
    'title' => $article['title'],
    'content' => $article['content'],
    'content_type' => $article['content_type'],
    'tone' => $article['tone'],
    'created_at' => $article['created_at']
]);
?>