<?php
require_once 'config.php';
require_once 'auth.php';

$auth = new Auth();

// Handle form submissions
if ($_POST) {
    if (isset($_POST['action'])) {
        switch ($_POST['action']) {
            case 'register':
                $result = $auth->register($_POST['username'], $_POST['email'], $_POST['password']);
                echo json_encode($result);
                exit;
                
            case 'login':
                $result = $auth->login($_POST['email'], $_POST['password']);
                echo json_encode($result);
                exit;
        }
    }
}

// Redirect if already logged in
if ($auth->isLoggedIn()) {
    header('Location: dashboard.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en" data-theme="light">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Uncensored AI Writer - Login</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <div class="auth-container">
        <div class="auth-card">
            <div class="text-center mb-3">
                <h1 style="font-size: 2rem; font-weight: 700; color: var(--primary-color); margin-bottom: 0.5rem;">
                    Uncensored AI Writer
                </h1>
                <p style="color: var(--text-secondary);">Advanced AI Content Generation Platform</p>
            </div>
            
            <div class="auth-tabs">
                <button class="auth-tab active" data-target="login">Login</button>
                <button class="auth-tab" data-target="register">Register</button>
            </div>
            
            <form id="loginForm" method="POST">
                <input type="hidden" name="action" value="login">
                
                <div class="form-group">
                    <label class="form-label" for="loginEmail">Email</label>
                    <input type="email" class="form-input" id="loginEmail" name="email" required>
                </div>
                
                <div class="form-group">
                    <label class="form-label" for="loginPassword">Password</label>
                    <input type="password" class="form-input" id="loginPassword" name="password" required>
                </div>
                
                <button type="submit" class="btn btn-primary btn-block">
                    Sign In
                </button>
            </form>
            
            <form id="registerForm" method="POST" class="hidden">
                <input type="hidden" name="action" value="register">
                
                <div class="form-group">
                    <label class="form-label" for="registerUsername">Username</label>
                    <input type="text" class="form-input" id="registerUsername" name="username" required>
                </div>
                
                <div class="form-group">
                    <label class="form-label" for="registerEmail">Email</label>
                    <input type="email" class="form-input" id="registerEmail" name="email" required>
                </div>
                
                <div class="form-group">
                    <label class="form-label" for="registerPassword">Password</label>
                    <input type="password" class="form-input" id="registerPassword" name="password" required>
                </div>
                
                <button type="submit" class="btn btn-primary btn-block">
                    Create Account
                </button>
            </form>
            
            <div class="text-center mt-3">
                <p style="color: var(--text-secondary); font-size: 0.875rem;">
                    By continuing, you agree to our Terms of Service
                </p>
            </div>
        </div>
    </div>

    <script src="script.js"></script>
    <script>
        // Handle form submissions
        document.addEventListener('DOMContentLoaded', function() {
            const loginForm = document.getElementById('loginForm');
            const registerForm = document.getElementById('registerForm');
            
            function handleFormSubmit(form, action) {
                form.addEventListener('submit', async function(e) {
                    e.preventDefault();
                    
                    const formData = new FormData(form);
                    const submitBtn = form.querySelector('button[type="submit"]');
                    const originalText = submitBtn.innerHTML;
                    
                    submitBtn.innerHTML = '<span class="loading"></span> Processing...';
                    submitBtn.disabled = true;
                    
                    try {
                        const response = await fetch('index.php', {
                            method: 'POST',
                            body: formData
                        });
                        
                        const result = await response.json();
                        
                        if (result.success) {
                            // Store user data and redirect
                            localStorage.setItem('userData', JSON.stringify({
                                email: formData.get('email')
                            }));
                            window.location.href = 'dashboard.php';
                        } else {
                            alert(result.message);
                        }
                    } catch (error) {
                        alert('An error occurred. Please try again.');
                    } finally {
                        submitBtn.innerHTML = originalText;
                        submitBtn.disabled = false;
                    }
                });
            }
            
            if (loginForm) handleFormSubmit(loginForm, 'login');
            if (registerForm) handleFormSubmit(registerForm, 'register');
        });
    </script>
</body>
</html>