<?php
require_once 'config.php';
require_once 'auth.php';

header('Content-Type: application/json');

$auth = new Auth();
if (!$auth->isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Not authenticated']);
    exit;
}

if ($_POST && isset($_POST['action']) && $_POST['action'] === 'process_donation') {
    $amount = floatval($_POST['amount']);
    $email = $_POST['email'] ?? '';
    
    if ($amount <= 0) {
        echo json_encode(['success' => false, 'message' => 'Invalid amount']);
        exit;
    }
    
    // In a real implementation, you would integrate with Flutterwave API here
    // This is a simplified simulation
    
    try {
        // Simulate payment processing
        $transactionId = 'unaiw_' . time() . '_' . uniqid();
        
        // Log the transaction (you would save this to your database)
        $pdo = getDBConnection();
        $stmt = $pdo->prepare("INSERT INTO transactions (user_id, amount, currency, transaction_id, status) VALUES (?, ?, 'USD', ?, 'completed')");
        $stmt->execute([$_SESSION['user_id'], $amount, $transactionId]);
        
        echo json_encode([
            'success' => true,
            'transaction_id' => $transactionId,
            'message' => 'Donation processed successfully. Thank you for your support!'
        ]);
        
    } catch (Exception $e) {
        echo json_encode(['success' => false, 'message' => 'Payment processing failed: ' . $e->getMessage()]);
    }
    
    exit;
}
?>