-- phpMyAdmin SQL Dump
-- version 5.2.2
-- https://www.phpmyadmin.net/
--
-- Host: localhost:3306
-- Generation Time: Sep 27, 2025 at 02:49 AM
-- Server version: 8.0.43
-- PHP Version: 8.4.11

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `fuzesale_unaiw`
--

DELIMITER $$
--
-- Procedures
--
CREATE DEFINER=`fuzesale`@`localhost` PROCEDURE `CreateUserSubscription` (IN `user_id` INT, IN `plan_type` ENUM('free','premium','enterprise'))   BEGIN
    DECLARE expires_date DATETIME;
    
    SET expires_date = CASE 
        WHEN plan_type = 'free' THEN DATE_ADD(NOW(), INTERVAL 30 DAY)
        WHEN plan_type = 'premium' THEN DATE_ADD(NOW(), INTERVAL 365 DAY)
        ELSE NULL -- Enterprise might not expire
    END;
    
    INSERT INTO subscriptions (user_id, plan_type, status, starts_at, expires_at) 
    VALUES (user_id, plan_type, 'active', NOW(), expires_date);
END$$

CREATE DEFINER=`fuzesale`@`localhost` PROCEDURE `ProcessNewArticle` (IN `user_id` INT, IN `article_title` VARCHAR(255), IN `article_content` TEXT)   BEGIN
    DECLARE word_count INT;
    
    -- Calculate word count
    SET word_count = LENGTH(article_content) - LENGTH(REPLACE(article_content, ' ', '')) + 1;
    
    -- Insert article
    INSERT INTO articles (user_id, title, content, word_count) 
    VALUES (user_id, article_title, article_content, word_count);
    
    -- Update user credits
    UPDATE users SET credits_remaining = credits_remaining - 1 WHERE id = user_id AND credits_remaining > 0;
    
    -- Create analytics entry
    INSERT INTO content_analytics (article_id) VALUES (LAST_INSERT_ID());
END$$

CREATE DEFINER=`fuzesale`@`localhost` PROCEDURE `UpdateAgentSuccessRate` (IN `agent_id` INT)   BEGIN
    DECLARE current_rate DECIMAL(5,2);
    DECLARE new_rate DECIMAL(5,2);
    
    SELECT success_rate INTO current_rate FROM ai_agents WHERE id = agent_id;
    
    -- Simple algorithm to gradually improve success rate with usage
    SET new_rate = LEAST(100.00, current_rate + 0.1);
    
    UPDATE ai_agents SET success_rate = new_rate WHERE id = agent_id;
END$$

DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `ai_agents`
--

CREATE TABLE `ai_agents` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `persona_config` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `expertise_area` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tone_style` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `creativity_level` enum('low','medium','high','very_high') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'medium',
  `is_default` tinyint(1) DEFAULT '0',
  `usage_count` int DEFAULT '0',
  `success_rate` decimal(5,2) DEFAULT '0.00',
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `ai_agents`
--

INSERT INTO `ai_agents` (`id`, `user_id`, `name`, `description`, `persona_config`, `expertise_area`, `tone_style`, `creativity_level`, `is_default`, `usage_count`, `success_rate`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 1, 'Lily SEO', 'Expert SEO content strategist with 10+ years experience', '{\"role\": \"SEO Expert\", \"experience\": \"10+ years\", \"specialties\": [\"SEO\", \"Content Strategy\", \"Digital Marketing\"], \"style\": \"Conversational, Mentor-like\", \"anecdotes\": true, \"contrarian_opinions\": true}', 'SEO & Content Marketing', 'Conversational', 'high', 1, 0, 95.00, 1, '2025-09-27 01:21:51', '2025-09-27 01:21:51'),
(2, 1, 'Technical Expert', 'Senior technical writer with deep industry knowledge', '{\"role\": \"Technical Expert\", \"experience\": \"15+ years\", \"specialties\": [\"Technology\", \"Software Development\", \"IT\"], \"style\": \"Professional, Detailed\", \"technical_depth\": \"high\"}', 'Technology & IT', 'Professional', 'medium', 0, 0, 92.00, 1, '2025-09-27 01:21:51', '2025-09-27 01:21:51'),
(3, 1, 'Creative Writer', 'Award-winning creative content specialist', '{\"role\": \"Creative Writer\", \"experience\": \"8+ years\", \"specialties\": [\"Storytelling\", \"Creative Writing\", \"Brand Voice\"], \"style\": \"Engaging, Emotional\", \"creativity\": \"very_high\"}', 'Creative Writing', 'Engaging', 'very_high', 0, 0, 89.00, 1, '2025-09-27 01:21:51', '2025-09-27 01:21:51');

-- --------------------------------------------------------

--
-- Table structure for table `api_usage_logs`
--

CREATE TABLE `api_usage_logs` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `api_type` enum('gemini','openai','anthropic') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'gemini',
  `endpoint` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `prompt_tokens` int DEFAULT NULL,
  `completion_tokens` int DEFAULT NULL,
  `total_tokens` int DEFAULT NULL,
  `cost` decimal(10,6) DEFAULT '0.000000',
  `response_time` decimal(8,3) DEFAULT NULL,
  `status_code` int DEFAULT NULL,
  `error_message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `articles`
--

CREATE TABLE `articles` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `content_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tone` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `word_count` int DEFAULT NULL,
  `focus_keyword` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `keywords` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `ai_agent` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target_audience` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content_outline` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `extra_instructions` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `addins` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `ai_settings` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `quality_score` int DEFAULT NULL,
  `humanlike_score` int DEFAULT NULL,
  `seo_score` int DEFAULT NULL,
  `detection_status` enum('undetected','suspected','detected') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'undetected',
  `is_public` tinyint(1) DEFAULT '0',
  `views_count` int DEFAULT '0',
  `downloads_count` int DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `article_categories`
--

CREATE TABLE `article_categories` (
  `id` int NOT NULL,
  `article_id` int NOT NULL,
  `category_id` int NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `backup_logs`
--

CREATE TABLE `backup_logs` (
  `id` int NOT NULL,
  `backup_type` enum('full','partial','incremental') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'full',
  `file_path` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_size` bigint DEFAULT NULL,
  `table_count` int DEFAULT NULL,
  `record_count` int DEFAULT NULL,
  `status` enum('success','failed','in_progress') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'in_progress',
  `error_message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_by` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `completed_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `categories`
--

CREATE TABLE `categories` (
  `id` int NOT NULL,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `parent_id` int DEFAULT NULL,
  `color` varchar(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '#6366f1',
  `icon` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sort_order` int DEFAULT '0',
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `categories`
--

INSERT INTO `categories` (`id`, `name`, `description`, `parent_id`, `color`, `icon`, `sort_order`, `is_active`, `created_at`) VALUES
(1, 'Technology', 'Articles about technology, software, and innovation', NULL, '#3B82F6', '💻', 1, 1, '2025-09-27 01:21:51'),
(2, 'Marketing', 'Digital marketing, SEO, and advertising content', NULL, '#10B981', '📈', 2, 1, '2025-09-27 01:21:51'),
(3, 'Business', 'Business strategies, entrepreneurship, and management', NULL, '#F59E0B', '💼', 3, 1, '2025-09-27 01:21:51'),
(4, 'Health & Wellness', 'Health, fitness, and wellness topics', NULL, '#EF4444', '❤️', 4, 1, '2025-09-27 01:21:51'),
(5, 'Education', 'Educational content and learning resources', NULL, '#8B5CF6', '🎓', 5, 1, '2025-09-27 01:21:51'),
(6, 'Entertainment', 'Entertainment, movies, and pop culture', NULL, '#EC4899', '🎬', 6, 1, '2025-09-27 01:21:51'),
(7, 'Web Development', 'Frontend and backend development topics', 1, '#3B82F6', '🌐', 7, 1, '2025-09-27 01:21:51'),
(8, 'AI & Machine Learning', 'Artificial intelligence and ML content', 1, '#6366F1', '🤖', 8, 1, '2025-09-27 01:21:51'),
(9, 'SEO Optimization', 'Search engine optimization techniques', 2, '#10B981', '🔍', 9, 1, '2025-09-27 01:21:51');

-- --------------------------------------------------------

--
-- Table structure for table `content_analytics`
--

CREATE TABLE `content_analytics` (
  `id` int NOT NULL,
  `article_id` int NOT NULL,
  `ai_detection_score` decimal(5,2) DEFAULT NULL,
  `readability_score` decimal(5,2) DEFAULT NULL,
  `seo_score` decimal(5,2) DEFAULT NULL,
  `engagement_score` decimal(5,2) DEFAULT NULL,
  `sentiment_score` decimal(5,2) DEFAULT NULL,
  `keyword_density` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `grammar_errors` int DEFAULT '0',
  `spelling_errors` int DEFAULT '0',
  `analyzed_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `export_history`
--

CREATE TABLE `export_history` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `article_id` int NOT NULL,
  `export_format` enum('doc','txt','pdf','html') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'doc',
  `file_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_size` int DEFAULT NULL,
  `export_settings` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `payment_transactions`
--

CREATE TABLE `payment_transactions` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `transaction_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `payment_gateway` enum('flutterwave','stripe','paystack') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'flutterwave',
  `amount` decimal(10,2) NOT NULL,
  `currency` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'USD',
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_status` enum('pending','completed','failed','refunded') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `gateway_response` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `customer_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip_address` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `subscriptions`
--

CREATE TABLE `subscriptions` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `plan_type` enum('free','premium','enterprise') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'free',
  `price` decimal(10,2) DEFAULT '0.00',
  `billing_cycle` enum('monthly','yearly','lifetime') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'monthly',
  `status` enum('active','canceled','expired','pending') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `starts_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `canceled_at` datetime DEFAULT NULL,
  `payment_transaction_id` int DEFAULT NULL,
  `features` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `limits` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `system_settings`
--

CREATE TABLE `system_settings` (
  `id` int NOT NULL,
  `setting_key` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `setting_value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `setting_type` enum('string','integer','boolean','json') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'string',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `is_public` tinyint(1) DEFAULT '0',
  `updated_by` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `system_settings`
--

INSERT INTO `system_settings` (`id`, `setting_key`, `setting_value`, `setting_type`, `description`, `is_public`, `updated_by`, `created_at`, `updated_at`) VALUES
(1, 'app_name', 'Uncensored AI Writer', 'string', 'Application display name', 1, 1, '2025-09-27 01:21:51', '2025-09-27 01:21:51'),
(2, 'app_version', '1.0.0', 'string', 'Current application version', 1, 1, '2025-09-27 01:21:51', '2025-09-27 01:21:51'),
(3, 'default_ai_agent', 'Lily SEO', 'string', 'Default AI agent for new users', 1, 1, '2025-09-27 01:21:51', '2025-09-27 01:21:51'),
(4, 'max_articles_free', '50', 'integer', 'Maximum articles for free tier', 1, 1, '2025-09-27 01:21:51', '2025-09-27 01:21:51'),
(5, 'max_articles_premium', '1000', 'integer', 'Maximum articles for premium tier', 1, 1, '2025-09-27 01:21:51', '2025-09-27 01:21:51'),
(6, 'api_rate_limit', '100', 'integer', 'API requests per hour limit', 0, 1, '2025-09-27 01:21:51', '2025-09-27 01:21:51'),
(7, 'default_timezone', 'UTC', 'string', 'Default timezone for the application', 1, 1, '2025-09-27 01:21:51', '2025-09-27 01:21:51'),
(8, 'maintenance_mode', '0', 'boolean', 'Whether maintenance mode is active', 1, 1, '2025-09-27 01:21:51', '2025-09-27 01:21:51'),
(9, 'registration_enabled', '1', 'boolean', 'Whether new user registration is enabled', 1, 1, '2025-09-27 01:21:51', '2025-09-27 01:21:51'),
(10, 'default_theme', 'light', 'string', 'Default theme for the application', 1, 1, '2025-09-27 01:21:51', '2025-09-27 01:21:51');

-- --------------------------------------------------------

--
-- Table structure for table `templates`
--

CREATE TABLE `templates` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `content_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tone` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_word_count` int DEFAULT '1000',
  `default_ai_agent` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `prompt_template` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `is_public` tinyint(1) DEFAULT '0',
  `usage_count` int DEFAULT '0',
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` int NOT NULL,
  `username` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `api_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_admin` tinyint(1) DEFAULT '0',
  `subscription_type` enum('free','premium','enterprise') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'free',
  `subscription_expires` datetime DEFAULT NULL,
  `credits_remaining` int DEFAULT '100',
  `last_login` datetime DEFAULT NULL,
  `ip_address` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `timezone` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'UTC',
  `preferences` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `username`, `email`, `password`, `api_key`, `is_admin`, `subscription_type`, `subscription_expires`, `credits_remaining`, `last_login`, `ip_address`, `timezone`, `preferences`, `created_at`, `updated_at`) VALUES
(1, 'aiadmin', 'prudenceeni@gmail.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', NULL, 1, 'enterprise', '2025-12-01 00:00:00', 999999, '2025-09-27 01:21:51', '127.0.0.1', 'UTC', '{\"theme\": \"dark\", \"results_per_page\": 50}', '2025-09-27 01:21:51', '2025-09-27 01:21:51'),
(2, 'penelope', 'penelopecampbell46@gmail.com', '$2y$10$hNWMmo0002lPO/JDYap6zOZBcMdzDxTfO4PmD4/FIHFWA/8iac8nm', 'AIzaSyAVsYGdeXGRYNs3FJ17ZW5qZamKN-LHxP4', 0, 'free', NULL, 100, NULL, NULL, 'UTC', NULL, '2025-09-27 01:29:45', '2025-09-27 01:30:20');

-- --------------------------------------------------------

--
-- Table structure for table `user_sessions`
--

CREATE TABLE `user_sessions` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `session_token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ip_address` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `last_activity` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `expires_at` timestamp NULL DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Indexes for dumped tables
--

--
-- Indexes for table `ai_agents`
--
ALTER TABLE `ai_agents`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `expertise_area` (`expertise_area`),
  ADD KEY `is_default` (`is_default`),
  ADD KEY `is_active` (`is_active`);

--
-- Indexes for table `api_usage_logs`
--
ALTER TABLE `api_usage_logs`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `api_type` (`api_type`),
  ADD KEY `created_at` (`created_at`),
  ADD KEY `status_code` (`status_code`);

--
-- Indexes for table `articles`
--
ALTER TABLE `articles`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `content_type` (`content_type`),
  ADD KEY `created_at` (`created_at`),
  ADD KEY `detection_status` (`detection_status`),
  ADD KEY `title` (`title`(191));
ALTER TABLE `articles` ADD FULLTEXT KEY `content_ft` (`content`);
ALTER TABLE `articles` ADD FULLTEXT KEY `title_ft` (`title`);

--
-- Indexes for table `article_categories`
--
ALTER TABLE `article_categories`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `article_category` (`article_id`,`category_id`),
  ADD KEY `category_id` (`category_id`);

--
-- Indexes for table `backup_logs`
--
ALTER TABLE `backup_logs`
  ADD PRIMARY KEY (`id`),
  ADD KEY `backup_type` (`backup_type`),
  ADD KEY `status` (`status`),
  ADD KEY `created_at` (`created_at`),
  ADD KEY `backup_logs_ibfk_1` (`created_by`);

--
-- Indexes for table `categories`
--
ALTER TABLE `categories`
  ADD PRIMARY KEY (`id`),
  ADD KEY `parent_id` (`parent_id`),
  ADD KEY `sort_order` (`sort_order`);

--
-- Indexes for table `content_analytics`
--
ALTER TABLE `content_analytics`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `article_id` (`article_id`),
  ADD KEY `ai_detection_score` (`ai_detection_score`),
  ADD KEY `readability_score` (`readability_score`);

--
-- Indexes for table `export_history`
--
ALTER TABLE `export_history`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `article_id` (`article_id`),
  ADD KEY `export_format` (`export_format`),
  ADD KEY `created_at` (`created_at`);

--
-- Indexes for table `payment_transactions`
--
ALTER TABLE `payment_transactions`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `transaction_id` (`transaction_id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `payment_status` (`payment_status`),
  ADD KEY `created_at` (`created_at`);

--
-- Indexes for table `subscriptions`
--
ALTER TABLE `subscriptions`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `plan_type` (`plan_type`),
  ADD KEY `status` (`status`),
  ADD KEY `expires_at` (`expires_at`);

--
-- Indexes for table `system_settings`
--
ALTER TABLE `system_settings`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `setting_key` (`setting_key`),
  ADD KEY `is_public` (`is_public`);

--
-- Indexes for table `templates`
--
ALTER TABLE `templates`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `content_type` (`content_type`),
  ADD KEY `is_public` (`is_public`);

--
-- Indexes for table `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `username` (`username`),
  ADD UNIQUE KEY `email` (`email`),
  ADD KEY `is_admin` (`is_admin`),
  ADD KEY `subscription_type` (`subscription_type`),
  ADD KEY `subscription_expires` (`subscription_expires`);

--
-- Indexes for table `user_sessions`
--
ALTER TABLE `user_sessions`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `session_token` (`session_token`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `expires_at` (`expires_at`),
  ADD KEY `is_active` (`is_active`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `ai_agents`
--
ALTER TABLE `ai_agents`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `api_usage_logs`
--
ALTER TABLE `api_usage_logs`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `articles`
--
ALTER TABLE `articles`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `article_categories`
--
ALTER TABLE `article_categories`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `backup_logs`
--
ALTER TABLE `backup_logs`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `categories`
--
ALTER TABLE `categories`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=10;

--
-- AUTO_INCREMENT for table `content_analytics`
--
ALTER TABLE `content_analytics`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `export_history`
--
ALTER TABLE `export_history`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `payment_transactions`
--
ALTER TABLE `payment_transactions`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `subscriptions`
--
ALTER TABLE `subscriptions`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `system_settings`
--
ALTER TABLE `system_settings`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=11;

--
-- AUTO_INCREMENT for table `templates`
--
ALTER TABLE `templates`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `users`
--
ALTER TABLE `users`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `user_sessions`
--
ALTER TABLE `user_sessions`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `ai_agents`
--
ALTER TABLE `ai_agents`
  ADD CONSTRAINT `ai_agents_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `api_usage_logs`
--
ALTER TABLE `api_usage_logs`
  ADD CONSTRAINT `api_usage_logs_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `articles`
--
ALTER TABLE `articles`
  ADD CONSTRAINT `articles_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `article_categories`
--
ALTER TABLE `article_categories`
  ADD CONSTRAINT `article_categories_ibfk_1` FOREIGN KEY (`article_id`) REFERENCES `articles` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `article_categories_ibfk_2` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `backup_logs`
--
ALTER TABLE `backup_logs`
  ADD CONSTRAINT `backup_logs_ibfk_1` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `content_analytics`
--
ALTER TABLE `content_analytics`
  ADD CONSTRAINT `content_analytics_ibfk_1` FOREIGN KEY (`article_id`) REFERENCES `articles` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `export_history`
--
ALTER TABLE `export_history`
  ADD CONSTRAINT `export_history_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `export_history_ibfk_2` FOREIGN KEY (`article_id`) REFERENCES `articles` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `payment_transactions`
--
ALTER TABLE `payment_transactions`
  ADD CONSTRAINT `payment_transactions_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `subscriptions`
--
ALTER TABLE `subscriptions`
  ADD CONSTRAINT `subscriptions_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `templates`
--
ALTER TABLE `templates`
  ADD CONSTRAINT `templates_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `user_sessions`
--
ALTER TABLE `user_sessions`
  ADD CONSTRAINT `user_sessions_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

DELIMITER $$
--
-- Events
--
CREATE DEFINER=`fuzesale`@`localhost` EVENT `cleanup_old_sessions` ON SCHEDULE EVERY 1 DAY STARTS '2025-09-27 01:21:52' ON COMPLETION NOT PRESERVE ENABLE DO DELETE FROM user_sessions WHERE expires_at < NOW() OR is_active = 0$$

CREATE DEFINER=`fuzesale`@`localhost` EVENT `update_subscription_statuses` ON SCHEDULE EVERY 1 DAY STARTS '2025-09-27 01:21:52' ON COMPLETION NOT PRESERVE ENABLE DO UPDATE subscriptions SET status = 'expired' WHERE expires_at < NOW() AND status = 'active'$$

DELIMITER ;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
