<?php
require_once '../config.php';
require_once '../auth.php';

if (!$auth->isLoggedIn() || !$auth->isAdmin()) {
    header('Location: ../membership.php');
    exit;
}

// Load users data
$usersData = json_decode(file_get_contents(USERS_FILE), true);
$users = $usersData['users'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel - Uncensored AI Writer</title>
    <link rel="stylesheet" href="../styles.css">
    <style>
        .admin-stats { display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 1rem; margin-bottom: 2rem; }
        .stat-card { background: var(--bg-secondary); padding: 1.5rem; border-radius: var(--radius); text-align: center; }
        .users-table { width: 100%; border-collapse: collapse; margin-top: 1rem; }
        .users-table th, .users-table td { padding: 1rem; text-align: left; border-bottom: 1px solid var(--border-color); }
        .admin-actions { display: flex; gap: 0.5rem; }
    </style>
</head>
<body>
    <header class="header">
        <nav class="nav">
            <div class="nav-brand">
                <h1>Admin Panel</h1>
            </div>
            <ul class="nav-menu">
                <li><a href="../writer.php">← Back to Writer</a></li>
                <li><a href="#" id="theme-toggle">🌙 Dark Mode</a></li>
                <li><a href="../logout.php">Logout</a></li>
            </ul>
        </nav>
    </header>

    <main class="admin-container">
        <div class="container">
            <h1>Administration Dashboard</h1>
            
            <div class="admin-stats">
                <div class="stat-card">
                    <h3>Total Users</h3>
                    <p class="stat-number"><?php echo count($users); ?></p>
                </div>
                <div class="stat-card">
                    <h3>Admin Users</h3>
                    <p class="stat-number"><?php echo count(array_filter($users, function($u) { return $u['role'] === 'admin'; })); ?></p>
                </div>
                <div class="stat-card">
                    <h3>Active Today</h3>
                    <p class="stat-number"><?php echo count(array_filter($users, function($u) { 
                        return $u['last_login'] && date('Y-m-d') === date('Y-m-d', strtotime($u['last_login'])); 
                    })); ?></p>
                </div>
            </div>

            <div class="admin-section">
                <h2>User Management</h2>
                <table class="users-table">
                    <thead>
                        <tr>
                            <th>Username</th>
                            <th>Email</th>
                            <th>Role</th>
                            <th>Last Login</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($users as $user): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($user['username']); ?></td>
                            <td><?php echo htmlspecialchars($user['email']); ?></td>
                            <td><?php echo htmlspecialchars($user['role']); ?></td>
                            <td><?php echo $user['last_login'] ? date('M j, Y g:i A', strtotime($user['last_login'])) : 'Never'; ?></td>
                            <td class="admin-actions">
                                <?php if ($user['username'] !== 'aiadmin'): ?>
                                    <button class="btn-secondary" onclick="changeRole('<?php echo $user['username']; ?>')">
                                        <?php echo $user['role'] === 'admin' ? 'Demote' : 'Promote'; ?>
                                    </button>
                                    <button class="btn-secondary" onclick="deleteUser('<?php echo $user['username']; ?>')">Delete</button>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

            <div class="admin-section">
                <h2>System Settings</h2>
                <div class="settings-grid">
                    <div class="setting-item">
                        <label for="max-file-size">Max File Size (MB)</label>
                        <input type="number" id="max-file-size" value="10" min="1" max="100">
                    </div>
                    <div class="setting-item">
                        <label for="max-users">Max Users</label>
                        <input type="number" id="max-users" value="1000" min="1">
                    </div>
                    <div class="setting-item">
                        <label for="api-timeout">API Timeout (seconds)</label>
                        <input type="number" id="api-timeout" value="30" min="5" max="120">
                    </div>
                </div>
                <button class="btn-primary" onclick="saveSettings()">Save Settings</button>
            </div>
        </div>
    </main>

    <script src="../script.js"></script>
    <script>
        function changeRole(username) {
            if (confirm('Are you sure you want to change this user\'s role?')) {
                // In a real implementation, this would make an AJAX call to update the user role
                alert('Role change functionality would be implemented here');
            }
        }

        function deleteUser(username) {
            if (confirm('Are you sure you want to delete this user? This action cannot be undone.')) {
                // In a real implementation, this would make an AJAX call to delete the user
                alert('User deletion functionality would be implemented here');
            }
        }

        function saveSettings() {
            // In a real implementation, this would save system settings
            alert('Settings saved successfully!');
        }
    </script>
</body>
</html>