<?php
// auth.php - Authentication Functions
require_once 'config.php';

class Auth {
    private $usersFile;
    
    public function __construct() {
        $this->usersFile = USERS_FILE;
        $this->initializeAdmin();
    }
    
    private function initializeAdmin() {
        $data = json_decode(file_get_contents($this->usersFile), true);
        
        if (!$data['admin_created']) {
            $adminUser = [
                'username' => 'aiadmin',
                'password' => password_hash('Eni23!ht', PASSWORD_DEFAULT),
                'email' => 'admin@vinesubtech.com.ng',
                'role' => 'admin',
                'created_at' => date('Y-m-d H:i:s'),
                'last_login' => null
            ];
            
            $data['users'][] = $adminUser;
            $data['admin_created'] = true;
            file_put_contents($this->usersFile, json_encode($data, JSON_PRETTY_PRINT));
        }
    }
    
    public function register($username, $email, $password) {
        // Validate email
        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            return ['success' => false, 'message' => 'Invalid email address'];
        }
        
        $data = json_decode(file_get_contents($this->usersFile), true);
        
        // Check if user exists
        foreach ($data['users'] as $user) {
            if ($user['email'] === $email || $user['username'] === $username) {
                return ['success' => false, 'message' => 'User already exists'];
            }
        }
        
        // Create new user
        $newUser = [
            'username' => $username,
            'email' => $email,
            'password' => password_hash($password, PASSWORD_DEFAULT),
            'role' => 'user',
            'created_at' => date('Y-m-d H:i:s'),
            'last_login' => date('Y-m-d H:i:s')
        ];
        
        $data['users'][] = $newUser;
        file_put_contents($this->usersFile, json_encode($data, JSON_PRETTY_PRINT));
        
        return ['success' => true, 'message' => 'Registration successful'];
    }
    
    public function login($username, $password) {
        $data = json_decode(file_get_contents($this->usersFile), true);
        
        foreach ($data['users'] as &$user) {
            if ($user['username'] === $username || $user['email'] === $username) {
                if (password_verify($password, $user['password'])) {
                    $user['last_login'] = date('Y-m-d H:i:s');
                    file_put_contents($this->usersFile, json_encode($data, JSON_PRETTY_PRINT));
                    
                    $_SESSION['user'] = $user;
                    return ['success' => true, 'user' => $user];
                }
            }
        }
        
        return ['success' => false, 'message' => 'Invalid credentials'];
    }
    
    public function isLoggedIn() {
        return isset($_SESSION['user']);
    }
    
    public function isAdmin() {
        return isset($_SESSION['user']) && $_SESSION['user']['role'] === 'admin';
    }
    
    public function logout() {
        session_destroy();
        header('Location: membership.php');
        exit;
    }
}

$auth = new Auth();
?>