<?php
// config.php - Application Configuration
session_start();

// Define base path
define('BASE_URL', (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]");

// File paths
define('USERS_FILE', 'users.json');
define('FILES_DIR', 'files/');

// Create files directory if it doesn't exist
if (!file_exists(FILES_DIR)) {
    mkdir(FILES_DIR, 0755, true);
}

// Initialize users.json if it doesn't exist
if (!file_exists(USERS_FILE)) {
    file_put_contents(USERS_FILE, json_encode(['users' => [], 'admin_created' => false]));
}
?>