<?php
require_once 'config.php';
require_once 'auth.php';

if (!$auth->isLoggedIn()) {
    header('Location: membership.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Support Developer - Uncensored AI Writer</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <header class="header">
        <nav class="nav">
            <div class="nav-brand">
                <h1>Uncensored AI Writer</h1>
            </div>
            <ul class="nav-menu">
                <li><a href="writer.php">← Back to Writer</a></li>
                <li><a href="#" id="theme-toggle">🌙 Dark Mode</a></li>
            </ul>
        </nav>
    </header>

    <main class="donation-container">
        <div class="container">
            <div class="donation-hero">
                <h1>Support the Developer 💝</h1>
                <p class="hero-subtitle">Your generous support helps maintain and improve this platform for everyone</p>
            </div>

            <div class="donation-content">
                <div class="donation-info">
                    <h2>Why Support Matters</h2>
                    <p>As an independent developer, I've poured countless hours into creating this platform to help content creators like you. Your support enables me to:</p>
                    <ul>
                        <li>🔄 Maintain and update the platform regularly</li>
                        <li>⚡ Improve server performance and response times</li>
                        <li>🔒 Enhance security and protect your data</li>
                        <li>🎨 Add new features and AI capabilities</li>
                        <li>💡 Keep the platform free from restrictive content filters</li>
                    </ul>
                    <p>Every contribution, no matter how small, makes a significant difference in keeping this service running smoothly.</p>
                </div>

                <div class="donation-form-container">
                    <div class="donation-card">
                        <h3>Make a Donation</h3>
                        <form id="donation-form">
                            <div class="form-group">
                                <label>Select Amount</label>
                                <div class="amount-buttons">
                                    <button type="button" class="amount-btn" data-amount="5">$5</button>
                                    <button type="button" class="amount-btn" data-amount="10">$10</button>
                                    <button type="button" class="amount-btn active" data-amount="25">$25</button>
                                    <button type="button" class="amount-btn" data-amount="50">$50</button>
                                    <button type="button" class="amount-btn" data-amount="100">$100</button>
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="custom-amount">Custom Amount ($)</label>
                                <input type="number" id="custom-amount" name="amount" value="25" min="1" step="0.01" required>
                            </div>

                            <div class="form-group">
                                <label for="donor-email">Email Address</label>
                                <input type="email" id="donor-email" name="email" required placeholder="Your email for receipt">
                            </div>

                            <div class="form-group">
                                <label for="donor-message">Optional Message</label>
                                <textarea id="donor-message" name="message" placeholder="Any message for the developer..."></textarea>
                            </div>

                            <button type="submit" class="btn-primary btn-large btn-full">Donate Now</button>
                        </form>

                        <div class="payment-methods">
                            <p>Secure payment processed by Flutterwave</p>
                            <div class="payment-icons">
                                <span>💳</span>
                                <span>🔒</span>
                                <span>🌍</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="donation-testimonials">
                <h2>What Supporters Say</h2>
                <div class="testimonials-grid">
                    <div class="testimonial-card">
                        <p>"I donated because this platform has literally transformed my content business. The developer deserves every penny!"</p>
                        <strong>- Mark T., Content Agency Owner</strong>
                    </div>
                    <div class="testimonial-card">
                        <p>"The level of support and regular updates show how much the developer cares. Happy to contribute to this amazing project."</p>
                        <strong>- Sarah L., Freelance Writer</strong>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <script src="hide/gem.js"></script>
    <script src="script.js"></script>
</body>
</html>