<?php
require_once 'config.php';
require_once 'auth.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Uncensored AI Writer - Create Human-Like Content That Bypasses AI Detection</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <header class="header">
        <nav class="nav">
            <div class="nav-brand">
                <h1>Uncensored AI Writer</h1>
            </div>
            <ul class="nav-menu">
                <li><a href="#features">Features</a></li>
                <li><a href="#testimonials">Testimonials</a></li>
                <li><a href="#pricing">Pricing</a></li>
                <li><a href="membership.php" class="btn-primary">Get Started</a></li>
            </ul>
            <div class="nav-toggle">
                <span></span>
                <span></span>
                <span></span>
            </div>
        </nav>
    </header>

    <main>
        <!-- Hero Section -->
        <section class="hero">
            <div class="container">
                <div class="hero-content">
                    <h1>Create Undetectable AI Content That Reads 100% Human</h1>
                    <p class="hero-subtitle">The world's first truly uncensored AI writing platform that generates content indistinguishable from human writing - guaranteed to bypass AI detection tools like ZeroGPT.</p>
                    <div class="hero-cta">
                        <a href="membership.php" class="btn-large">Start Creating Free</a>
                        <a href="#demo" class="btn-secondary">See Live Demo</a>
                    </div>
                    <div class="hero-stats">
                        <div class="stat">
                            <span class="stat-number">10,000+</span>
                            <span class="stat-label">Articles Generated</span>
                        </div>
                        <div class="stat">
                            <span class="stat-number">99.7%</span>
                            <span class="stat-label">AI Detection Bypass Rate</span>
                        </div>
                        <div class="stat">
                            <span class="stat-number">4.9/5</span>
                            <span class="stat-label">User Rating</span>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Features Section -->
        <section id="features" class="features">
            <div class="container">
                <h2>Why Content Creators Are Switching To Uncensored AI Writer</h2>
                <div class="features-grid">
                    <div class="feature-card">
                        <div class="feature-icon">🔍</div>
                        <h3>Zero AI Detection</h3>
                        <p>Our advanced algorithms create content that consistently passes AI detection tools with flying colors.</p>
                    </div>
                    <div class="feature-card">
                        <div class="feature-icon">🚫</div>
                        <h3>No Content Restrictions</h3>
                        <p>Write about any topic without limitations - adult content, sensitive subjects, and more.</p>
                    </div>
                    <div class="feature-card">
                        <div class="feature-icon">⚡</div>
                        <h3>Real-Time Streaming</h3>
                        <p>Watch your content generate word-by-word with our live streaming technology.</p>
                    </div>
                    <div class="feature-card">
                        <div class="feature-icon">🎭</div>
                        <h3>Custom AI Personas</h3>
                        <p>Create unlimited AI writing agents with unique personalities and expertise.</p>
                    </div>
                    <div class="feature-card">
                        <div class="feature-icon">💾</div>
                        <h3>Smart Storage</h3>
                        <p>Save, edit, and export your content in multiple formats with our organized file system.</p>
                    </div>
                    <div class="feature-card">
                        <div class="feature-icon">🌙</div>
                        <h3>Dark/Light Mode</h3>
                        <p>Work comfortably with our seamless theme switching capability.</p>
                    </div>
                </div>
            </div>
        </section>

        <!-- Demo Section -->
        <section id="demo" class="demo">
            <div class="container">
                <h2>See The Magic In Action</h2>
                <div class="demo-container">
                    <div class="demo-input">
                        <h3>Input Your Topic</h3>
                        <input type="text" placeholder="Enter any topic..." value="The future of AI in content creation">
                    </div>
                    <div class="demo-output">
                        <h3>Human-Like Output</h3>
                        <div class="output-content">
                            <p>I've been in the content game for over a decade, and let me tell you - the AI revolution is both terrifying and exhilarating. I remember when I first started out, spending hours researching and writing a single blog post...</p>
                            <p>Most "experts" will tell you AI will replace human writers. I call BS. The real opportunity lies in collaboration, not replacement. Here's what most people get wrong...</p>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Testimonials Section -->
        <section id="testimonials" class="testimonials">
            <div class="container">
                <h2>What Our Users Say</h2>
                <div class="testimonials-grid">
                    <div class="testimonial-card">
                        <div class="testimonial-content">
                            <p>"This platform saved my business. I was struggling with AI detection on my content until I found Uncensored AI Writer. Now my articles pass every detection tool with flying colors!"</p>
                        </div>
                        <div class="testimonial-author">
                            <strong>Sarah Johnson</strong>
                            <span>Content Agency Owner</span>
                        </div>
                    </div>
                    <div class="testimonial-card">
                        <div class="testimonial-content">
                            <p>"The custom AI agents feature is game-changing. I've created personas for different clients, and the content quality is consistently exceptional. Best investment I've made this year."</p>
                        </div>
                        <div class="testimonial-author">
                            <strong>Mike Chen</strong>
                            <span>Freelance Writer</span>
                        </div>
                    </div>
                    <div class="testimonial-card">
                        <div class="testimonial-content">
                            <p>"As someone who writes about sensitive topics, the uncensored nature of this platform is crucial. Finally, an AI that doesn't restrict my creative freedom."</p>
                        </div>
                        <div class="testimonial-author">
                            <strong>Dr. Emily Roberts</strong>
                            <span>Researcher & Author</span>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- CTA Section -->
        <section class="cta">
            <div class="container">
                <h2>Ready to Create Undetectable AI Content?</h2>
                <p>Join thousands of content creators who are already bypassing AI detection with our platform.</p>
                <a href="membership.php" class="btn-large">Start Your Free Trial Now</a>
                <p class="cta-note">No credit card required • 100% satisfaction guarantee</p>
            </div>
        </section>
    </main>

    <footer class="footer">
        <div class="container">
            <p>&copy; 2024 Uncensored AI Writer. Developed by Emmanuel Abimbola (VinesubTech). All rights reserved.</p>
        </div>
    </footer>

    <script src="script.js"></script>
</body>
</html>