<?php
require_once 'config.php';
require_once 'auth.php';

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['register'])) {
        $result = $auth->register($_POST['username'], $_POST['email'], $_POST['password']);
        if ($result['success']) {
            $success = 'Registration successful! Please login.';
        } else {
            $error = $result['message'];
        }
    } elseif (isset($_POST['login'])) {
        $result = $auth->login($_POST['username'], $_POST['password']);
        if ($result['success']) {
            header('Location: writer.php');
            exit;
        } else {
            $error = $result['message'];
        }
    }
}

if ($auth->isLoggedIn()) {
    header('Location: writer.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login / Register - Uncensored AI Writer</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body class="auth-page">
    <header class="header">
        <nav class="nav">
            <div class="nav-brand">
                <h1>Uncensored AI Writer</h1>
            </div>
            <ul class="nav-menu">
                <li><a href="index.php">Home</a></li>
                <li><a href="index.php#features">Features</a></li>
            </ul>
        </nav>
    </header>

    <main class="auth-container">
        <div class="auth-tabs">
            <button class="tab-button active" data-tab="login">Login</button>
            <button class="tab-button" data-tab="register">Register</button>
        </div>

        <?php if ($error): ?>
            <div class="alert alert-error"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>
        
        <?php if ($success): ?>
            <div class="alert alert-success"><?php echo htmlspecialchars($success); ?></div>
        <?php endif; ?>

        <div class="tab-content active" id="login-tab">
            <form method="POST" class="auth-form">
                <input type="hidden" name="login" value="1">
                <div class="form-group">
                    <label for="login-username">Username or Email</label>
                    <input type="text" id="login-username" name="username" required>
                </div>
                <div class="form-group">
                    <label for="login-password">Password</label>
                    <input type="password" id="login-password" name="password" required>
                </div>
                <button type="submit" class="btn-primary btn-full">Login</button>
            </form>
        </div>

        <div class="tab-content" id="register-tab">
            <form method="POST" class="auth-form">
                <input type="hidden" name="register" value="1">
                <div class="form-group">
                    <label for="register-username">Username</label>
                    <input type="text" id="register-username" name="username" required>
                </div>
                <div class="form-group">
                    <label for="register-email">Email</label>
                    <input type="email" id="register-email" name="email" required>
                </div>
                <div class="form-group">
                    <label for="register-password">Password</label>
                    <input type="password" id="register-password" name="password" required>
                </div>
                <button type="submit" class="btn-primary btn-full">Register</button>
            </form>
        </div>

        <div class="auth-footer">
            <p>Default Admin: Username: <strong>aiadmin</strong> | Password: <strong>Eni23!ht</strong></p>
        </div>
    </main>

    <script src="script.js"></script>
</body>
</html>