<?php
// admin.php - Advanced Admin Panel
require_once 'config.php';
require_once 'inc/database.inc.php';
require_once 'inc/user.inc.php';
require_once 'inc/admin-functions.inc.php';

$db = new Database();
$user = new User($db);
$admin = new AdminFunctions($db);

// Check admin authentication
if (!$user->isLoggedIn() || !$admin->isUserAdmin($user->getUserData()['id'])) {
    header('Location: index.php');
    exit;
}

$current_section = $_GET['section'] ?? 'dashboard';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel - <?php echo APP_NAME; ?></title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/admin.css">
</head>
<body class="admin-body">
    <div class="admin-container">
        <!-- Sidebar Navigation -->
        <nav class="admin-sidebar">
            <div class="admin-brand">
                <h2><?php echo APP_NAME; ?> Admin</h2>
            </div>
            <ul class="admin-menu">
                <li class="<?php echo $current_section === 'dashboard' ? 'active' : ''; ?>">
                    <a href="?section=dashboard">📊 Dashboard</a>
                </li>
                <li class="<?php echo $current_section === 'users' ? 'active' : ''; ?>">
                    <a href="?section=users">👥 User Management</a>
                </li>
                <li class="<?php echo $current_section === 'subscriptions' ? 'active' : ''; ?>">
                    <a href="?section=subscriptions">💳 Subscriptions</a>
                </li>
                <li class="<?php echo $current_section === 'payments' ? 'active' : ''; ?>">
                    <a href="?section=payments">💰 Payments</a>
                </li>
                <li class="<?php echo $current_section === 'ai-agents' ? 'active' : ''; ?>">
                    <a href="?section=ai-agents">🤖 AI Agents</a>
                </li>
                <li class="<?php echo $current_section === 'content' ? 'active' : ''; ?>">
                    <a href="?section=content">📝 Content Moderation</a>
                </li>
                <li class="<?php echo $current_section === 'settings' ? 'active' : ''; ?>">
                    <a href="?section=settings">⚙️ Settings</a>
                </li>
            </ul>
        </nav>

        <!-- Main Content -->
        <main class="admin-main">
            <header class="admin-header">
                <div class="admin-user">
                    <span>Welcome, <?php echo htmlspecialchars($user->getUserData()['full_name']); ?></span>
                    <a href="?logout" class="btn-logout">Logout</a>
                </div>
            </header>

            <div class="admin-content">
                <?php
                switch ($current_section) {
                    case 'dashboard':
                        include 'inc/admin-sections/dashboard.php';
                        break;
                    case 'users':
                        include 'inc/admin-sections/users.php';
                        break;
                    case 'subscriptions':
                        include 'inc/admin-sections/subscriptions.php';
                        break;
                    case 'payments':
                        include 'inc/admin-sections/payments.php';
                        break;
                    case 'ai-agents':
                        include 'inc/admin-sections/ai-agents.php';
                        break;
                    case 'content':
                        include 'inc/admin-sections/content.php';
                        break;
                    case 'settings':
                        include 'inc/admin-sections/settings.php';
                        break;
                    default:
                        include 'inc/admin-sections/dashboard.php';
                        break;
                }
                ?>
            </div>
        </main>
    </div>

    <script src="assets/js/admin.js"></script>
</body>
</html>