<?php
// auth.php - Authentication Handler

require_once 'config.php';
require_once 'inc/database.inc.php';
require_once 'inc/user.inc.php';

$db = new Database();
$user = new User($db);

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';

    switch ($action) {
        case 'register':
            $email = filter_var($_POST['email'] ?? '', FILTER_SANITIZE_EMAIL);
            $password = $_POST['password'] ?? '';
            $full_name = filter_var($_POST['full_name'] ?? '', FILTER_SANITIZE_STRING);

            if (empty($email) || empty($password) || empty($full_name)) {
                echo json_encode(['success' => false, 'message' => 'All fields are required']);
                exit;
            }

            $result = $user->register($email, $password, $full_name);
            echo json_encode($result);
            break;

        case 'verify':
            $email = filter_var($_POST['email'] ?? '', FILTER_SANITIZE_EMAIL);
            $code = $_POST['code'] ?? '';

            if (empty($email) || empty($code)) {
                echo json_encode(['success' => false, 'message' => 'Email and code are required']);
                exit;
            }

            $result = $user->verifyAccount($email, $code);
            echo json_encode($result);
            break;

        case 'login':
            $email = filter_var($_POST['email'] ?? '', FILTER_SANITIZE_EMAIL);
            $password = $_POST['password'] ?? '';

            if (empty($email) || empty($password)) {
                echo json_encode(['success' => false, 'message' => 'Email and password are required']);
                exit;
            }

            $result = $user->login($email, $password);
            echo json_encode($result);
            break;

        case 'logout':
            $user->logout();
            echo json_encode(['success' => true, 'message' => 'Logged out successfully']);
            break;

        default:
            echo json_encode(['success' => false, 'message' => 'Invalid action']);
            break;
    }
}
?>