<?php
class AdminFunctions {
    private $db;

    public function __construct($database) {
        $this->db = $database;
    }

    public function isUserAdmin($user_id) {
        $user = $this->db->query(
            "SELECT email FROM users WHERE id = ? AND (email LIKE '%admin%' OR subscription_tier = 'admin')",
            [$user_id]
        )->fetch();
        
        return !empty($user);
    }

    public function getDashboardStats() {
        $stats = [];

        // Total users
        $result = $this->db->query("SELECT COUNT(*) as total FROM users")->fetch();
        $stats['total_users'] = $result['total'];

        // Active subscriptions
        $result = $this->db->query("SELECT COUNT(*) as total FROM subscriptions WHERE status = 'active' AND expires_at > NOW()")->fetch();
        $stats['active_subscriptions'] = $result['total'];

        // Total revenue
        $result = $this->db->query("SELECT SUM(amount) as total FROM payments WHERE status = 'completed'")->fetch();
        $stats['total_revenue'] = $result['total'] ?? 0;

        // Today's usage
        $result = $this->db->query("SELECT COUNT(*) as total FROM ai_content WHERE DATE(created_at) = CURDATE()")->fetch();
        $stats['today_articles'] = $result['total'];

        return $stats;
    }

    public function getUserList($page = 1, $per_page = 20) {
        $offset = ($page - 1) * $per_page;
        
        $users = $this->db->query(
            "SELECT u.*, 
                    (SELECT COUNT(*) FROM ai_content WHERE user_id = u.id) as article_count,
                    (SELECT MAX(expires_at) FROM subscriptions WHERE user_id = u.id AND status = 'active') as subscription_ends
             FROM users u 
             ORDER BY u.created_at DESC 
             LIMIT ? OFFSET ?",
            [$per_page, $offset]
        )->fetchAll();

        return $users;
    }

    public function updateSystemSettings($settings) {
        foreach ($settings as $key => $value) {
            $this->db->query(
                "INSERT INTO system_settings (setting_key, setting_value) 
                 VALUES (?, ?) 
                 ON DUPLICATE KEY UPDATE setting_value = ?",
                [$key, $value, $value]
            );
        }
        return true;
    }

    public function logAdminAction($admin_id, $action, $target_user_id = null) {
        $this->db->query(
            "INSERT INTO admin_logs (admin_id, action, target_user_id, ip_address) 
             VALUES (?, ?, ?, ?)",
            [$admin_id, $action, $target_user_id, $_SERVER['REMOTE_ADDR']]
        );
    }
}
?>