<?php
require_once 'config.php';
require_once 'inc/database.inc.php';
require_once 'inc/payment.inc.php';

$db = new Database();
$payment_handler = new PaymentHandler($db);

$input = file_get_contents('php://input');
$payload = json_decode($input, true);
$gateway = $_GET['gateway'] ?? '';

if ($gateway === 'flutterwave') {
    // Verify Flutterwave webhook signature
    $signature = $_SERVER['HTTP_VERIF_HASH'] ?? '';
    
    if ($signature === FLW_SECRET_HASH) { // Add to config.php
        $transaction_ref = $payload['data']['tx_ref'] ?? '';
        $status = $payload['data']['status'] ?? '';
        
        if ($status === 'successful') {
            // Verify transaction
            $verification = $payment_handler->verifyFlutterwavePayment($transaction_ref);
            
            if ($verification['success']) {
                // Activate user subscription
                $payment_data = $verification['data'];
                $user_id = extractUserIdFromRef($transaction_ref); // Implement this
                
                // Update payment status
                $db->query(
                    "UPDATE payments SET status = 'completed' WHERE transaction_ref = ?",
                    [$transaction_ref]
                );
                
                // Activate subscription
                // Implement based on your business logic
            }
        }
    }
}

http_response_code(200);
echo 'Webhook processed';
?>