<?php
require_once 'config.php';

// Redirect if not logged in
if (!is_logged_in()) {
    redirect('login.php');
}

$settings = get_settings();
$user_id = $_SESSION['user_id'];
$user_licenses = get_user_licenses($user_id);
$user_transactions = get_user_transactions($user_id);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - <?php echo $settings['site_name']; ?></title>
    <link rel="stylesheet" href="styles.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <header class="header">
        <div class="container">
            <div class="logo">
                <h1><i class="fas fa-key"></i> <?php echo $settings['site_name']; ?></h1>
            </div>
            <nav class="nav">
                <a href="index.php">Home</a>
                <a href="pricing.php">Pricing</a>
                <?php if (is_admin()): ?>
                <a href="admin.php">Admin</a>
                <?php endif; ?>
                <a href="logout.php">Logout</a>
            </nav>
            <div class="mobile-menu-btn">
                <i class="fas fa-bars"></i>
            </div>
        </div>
    </header>

    <main class="dashboard">
        <div class="container">
            <div class="dashboard-header">
                <h2>Welcome, <?php echo $_SESSION['username']; ?>!</h2>
                <a href="pricing.php" class="btn btn-primary">Purchase New License</a>
            </div>

            <div class="dashboard-cards">
                <div class="dashboard-card">
                    <h3>Active Licenses</h3>
                    <div class="number"><?php echo count(array_filter($user_licenses, function($license) { 
                        return $license['status'] === 'active' && strtotime($license['expires_at']) > time(); 
                    })); ?></div>
                </div>
                <div class="dashboard-card">
                    <h3>Total Transactions</h3>
                    <div class="number"><?php echo count($user_transactions); ?></div>
                </div>
                <div class="dashboard-card">
                    <h3>Active Websites</h3>
                    <div class="number"><?php 
                        $active_domains = 0;
                        foreach ($user_licenses as $license) {
                            if ($license['status'] === 'active' && strtotime($license['expires_at']) > time()) {
                                $active_domains += isset($license['domains']) ? count($license['domains']) : 0;
                            }
                        }
                        echo $active_domains;
                    ?></div>
                </div>
            </div>

            <div class="dashboard-section">
                <h3>Your License Keys</h3>
                
                <?php if (empty($user_licenses)): ?>
                <p>You don't have any license keys yet. <a href="pricing.php">Purchase one now</a>.</p>
                <?php else: ?>
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>License Key</th>
                                <th>Plan</th>
                                <th>Status</th>
                                <th>Expires</th>
                                <th>Domains</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($user_licenses as $license): 
                                $plan = get_plan_by_id($license['plan_id']);
                                $is_expired = strtotime($license['expires_at']) < time();
                            ?>
                            <tr>
                                <td><code><?php echo $license['key']; ?></code></td>
                                <td><?php echo $plan['name']; ?></td>
                                <td>
                                    <span class="<?php echo ($license['status'] === 'active' && !$is_expired) ? 'status-active' : 'status-inactive'; ?>">
                                        <?php echo ($license['status'] === 'active' && !$is_expired) ? 'Active' : 'Inactive'; ?>
                                    </span>
                                </td>
                                <td><?php echo date('M j, Y', strtotime($license['expires_at'])); ?></td>
                                <td>
                                    <?php if (isset($license['domains']) && !empty($license['domains'])): ?>
                                        <?php echo count($license['domains']); ?> domain(s)
                                    <?php else: ?>
                                        0 domains
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <button class="btn btn-secondary copy-license" data-license="<?php echo $license['key']; ?>">Copy</button>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                <?php endif; ?>
            </div>

            <div class="dashboard-section">
                <h3>Recent Transactions</h3>
                
                <?php if (empty($user_transactions)): ?>
                <p>No transactions found.</p>
                <?php else: ?>
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Transaction ID</th>
                                <th>Plan</th>
                                <th>Amount</th>
                                <th>Date</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach (array_slice($user_transactions, 0, 5) as $transaction): 
                                $plan = get_plan_by_id($transaction['plan_id']);
                            ?>
                            <tr>
                                <td><?php echo $transaction['tx_ref']; ?></td>
                                <td><?php echo $plan['name']; ?></td>
                                <td>₦<?php echo number_format($transaction['amount']); ?></td>
                                <td><?php echo date('M j, Y H:i', strtotime($transaction['created_at'])); ?></td>
                                <td>
                                    <span class="status-active">Completed</span>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </main>

    <footer class="footer">
        <div class="container">
            <div class="footer-content">
                <div class="footer-section">
                    <h3><?php echo $settings['site_name']; ?></h3>
                    <p>Advanced AI writing tool for WordPress that generates human-like content without restrictions.</p>
                </div>
                <div class="footer-section">
                    <h4>Quick Links</h4>
                    <ul>
                        <li><a href="index.php">Home</a></li>
                        <li><a href="pricing.php">Pricing</a></li>
                        <li><a href="dashboard.php">Dashboard</a></li>
                    </ul>
                </div>
                <div class="footer-section">
                    <h4>Support</h4>
                    <ul>
                        <li><a href="#">Documentation</a></li>
                        <li><a href="#">Contact Us</a></li>
                        <li><a href="#">Privacy Policy</a></li>
                        <li><a href="#">Terms of Service</a></li>
                    </ul>
                </div>
                <div class="footer-section">
                    <h4>Contact Info</h4>
                    <p><i class="fas fa-envelope"></i> <?php echo $settings['support_email']; ?></p>
                    <p><i class="fas fa-map-marker-alt"></i> <?php echo $settings['company_address']; ?></p>
                </div>
            </div>
            <div class="footer-bottom">
                <p>&copy; <?php echo date('Y'); ?> <?php echo $settings['company_name']; ?>. All rights reserved.</p>
            </div>
        </div>
    </footer>

    <script>
        // Copy license key to clipboard
        document.querySelectorAll('.copy-license').forEach(button => {
            button.addEventListener('click', function() {
                const licenseKey = this.getAttribute('data-license');
                navigator.clipboard.writeText(licenseKey).then(() => {
                    const originalText = this.textContent;
                    this.textContent = 'Copied!';
                    setTimeout(() => {
                        this.textContent = originalText;
                    }, 2000);
                });
            });
        });
    </script>
    <script src="script.js"></script>
</body>
</html>