<?php
require_once 'config.php';

// Redirect to dashboard if already logged in
if (is_logged_in()) {
    redirect('dashboard.php');
}

$settings = get_settings();
$plans = json_decode(file_get_contents(PLANS_JSON), true);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $settings['site_name']; ?> - AI Writing Plugin License Manager</title>
    <link rel="stylesheet" href="styles.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <header class="header">
        <div class="container">
            <div class="logo">
                <h1><i class="fas fa-key"></i> <?php echo $settings['site_name']; ?></h1>
            </div>
            <nav class="nav">
                <a href="index.php" class="active">Home</a>
                <a href="pricing.php">Pricing</a>
                <a href="register.php">Register</a>
                <a href="login.php">Login</a>
            </nav>
            <div class="mobile-menu-btn">
                <i class="fas fa-bars"></i>
            </div>
        </div>
    </header>

    <section class="hero">
        <div class="container">
            <div class="hero-content">
                <h1>Unlock the Full Power of Vine AI Writing Plugin</h1>
                <p>Purchase a license key to access all features of our advanced AI writing tool for WordPress. Generate unlimited human-like content without restrictions.</p>
                <div class="hero-buttons">
                    <a href="pricing.php" class="btn btn-primary">Get Started</a>
                    <a href="#features" class="btn btn-secondary">Learn More</a>
                </div>
            </div>
            <div class="hero-image">
                <img src="https://images.unsplash.com/photo-1611224923853-80b023f02d71?ixlib=rb-4.0.3&ixid=MnwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8&auto=format&fit=crop&w=1000&q=80" alt="AI Writing">
            </div>
        </div>
    </section>

    <section id="features" class="features">
        <div class="container">
            <h2>Why Choose Vine AI Writing Plugin?</h2>
            <div class="features-grid">
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-brain"></i>
                    </div>
                    <h3>Advanced AI Technology</h3>
                    <p>Powered by Gemini 2.0 Flash API for the most human-like content generation</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-shield-alt"></i>
                    </div>
                    <h3>No Censorship</h3>
                    <p>Generate any type of content without restrictions or limitations</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-user-secret"></i>
                    </div>
                    <h3>AI Detection Evasion</h3>
                    <p>Content that passes all AI detection tools as 100% human-written</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-users"></i>
                    </div>
                    <h3>Multiple Personas</h3>
                    <p>Create unlimited AI writing personas for different content styles</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-sync-alt"></i>
                    </div>
                    <h3>Automatic Updates</h3>
                    <p>Regular updates with new features and improvements</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-headset"></i>
                    </div>
                    <h3>Priority Support</h3>
                    <p>Dedicated support team to help with any issues</p>
                </div>
            </div>
        </div>
    </section>

    <section class="pricing-preview">
        <div class="container">
            <h2>Simple, Transparent Pricing</h2>
            <p>Choose the plan that works best for your needs</p>
            
            <div class="pricing-grid">
                <?php foreach ($plans as $plan): if ($plan['is_active']): ?>
                <div class="pricing-card">
                    <h3><?php echo $plan['name']; ?></h3>
                    <div class="price">₦<?php echo number_format($plan['price']); ?></div>
                    <p>One-time payment</p>
                    <ul>
                        <?php foreach ($plan['features'] as $feature): ?>
                        <li><i class="fas fa-check"></i> <?php echo $feature; ?></li>
                        <?php endforeach; ?>
                    </ul>
                    <a href="register.php?plan=<?php echo $plan['id']; ?>" class="btn btn-primary">Get Started</a>
                </div>
                <?php endif; endforeach; ?>
            </div>
            
            <div class="center">
                <a href="pricing.php" class="btn btn-secondary">View All Plans</a>
            </div>
        </div>
    </section>

    <section class="testimonials">
        <div class="container">
            <h2>What Our Customers Say</h2>
            <div class="testimonials-grid">
                <div class="testimonial-card">
                    <div class="testimonial-content">
                        <p>"The Vine AI plugin has completely transformed my content creation process. The articles are so human-like that my readers can't tell the difference!"</p>
                    </div>
                    <div class="testimonial-author">
                        <h4>Sarah Johnson</h4>
                        <p>Content Marketer</p>
                    </div>
                </div>
                <div class="testimonial-card">
                    <div class="testimonial-content">
                        <p>"I've tried many AI writing tools, but Vine AI is by far the best. The ability to create custom personas is a game-changer for my business."</p>
                    </div>
                    <div class="testimonial-author">
                        <h4>Michael Chen</h4>
                        <p>Blog Owner</p>
                    </div>
                </div>
                <div class="testimonial-card">
                    <div class="testimonial-content">
                        <p>"The license management system is seamless. I purchased my key and was up and running in minutes. The support team is also very responsive."</p>
                    </div>
                    <div class="testimonial-author">
                        <h4>Amanda Rodriguez</h4>
                        <p>Digital Agency Owner</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="faq">
        <div class="container">
            <h2>Frequently Asked Questions</h2>
            <div class="faq-list">
                <div class="faq-item">
                    <h3>How does the license key work? <i class="fas fa-chevron-down"></i></h3>
                    <div class="faq-answer">
                        <p>After purchase, you'll receive a unique license key that you can enter in your WordPress plugin settings. This key unlocks all premium features and connects to our validation system.</p>
                    </div>
                </div>
                <div class="faq-item">
                    <h3>Can I use one license on multiple websites? <i class="fas fa-chevron-down"></i></h3>
                    <div class="faq-answer">
                        <p>It depends on your plan. The Basic plan allows one website, Professional allows three websites, and Enterprise allows unlimited websites.</p>
                    </div>
                </div>
                <div class="faq-item">
                    <h3>What payment methods do you accept? <i class="fas fa-chevron-down"></i></h3>
                    <div class="faq-answer">
                        <p>We accept all major credit cards, bank transfers, and mobile money through our secure Flutterwave payment gateway.</p>
                    </div>
                </div>
                <div class="faq-item">
                    <h3>How long does the license last? <i class="fas fa-chevron-down"></i></h3>
                    <div class="faq-answer">
                        <p>All plans include one year of updates and support. After one year, you can renew at a discounted rate to continue receiving updates and support.</p>
                    </div>
                </div>
                <div class="faq-item">
                    <h3>What if I need help with the plugin? <i class="fas fa-chevron-down"></i></h3>
                    <div class="faq-answer">
                        <p>We offer dedicated support based on your plan. Basic plan users get email support, Professional plan users get priority support, and Enterprise users get 24/7 support.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <footer class="footer">
        <div class="container">
            <div class="footer-content">
                <div class="footer-section">
                    <h3><?php echo $settings['site_name']; ?></h3>
                    <p>Advanced AI writing tool for WordPress that generates human-like content without restrictions.</p>
                </div>
                <div class="footer-section">
                    <h4>Quick Links</h4>
                    <ul>
                        <li><a href="index.php">Home</a></li>
                        <li><a href="pricing.php">Pricing</a></li>
                        <li><a href="register.php">Register</a></li>
                    </ul>
                </div>
                <div class="footer-section">
                    <h4>Support</h4>
                    <ul>
                        <li><a href="#">Documentation</a></li>
                        <li><a href="#">Contact Us</a></li>
                        <li><a href="#">Privacy Policy</a></li>
                        <li><a href="#">Terms of Service</a></li>
                    </ul>
                </div>
                <div class="footer-section">
                    <h4>Contact Info</h4>
                    <p><i class="fas fa-envelope"></i> <?php echo $settings['support_email']; ?></p>
                    <p><i class="fas fa-map-marker-alt"></i> <?php echo $settings['company_address']; ?></p>
                </div>
            </div>
            <div class="footer-bottom">
                <p>&copy; <?php echo date('Y'); ?> <?php echo $settings['company_name']; ?>. All rights reserved.</p>
            </div>
        </div>
    </footer>

    <script src="script.js"></script>
</body>
</html>