<?php
require_once 'config.php';

// Redirect if not logged in
if (!is_logged_in()) {
    redirect('login.php');
}

$settings = get_settings();
$user_id = $_SESSION['user_id'];
$user_licenses = get_user_licenses($user_id);

// Handle license actions
if (isset($_GET['action']) && isset($_GET['license_key'])) {
    $license_key = $_GET['license_key'];
    $licenses = json_decode(file_get_contents(LICENSES_JSON), true);
    
    foreach ($licenses as $index => $license) {
        if ($license['key'] === $license_key && $license['user_id'] === $user_id) {
            if ($_GET['action'] === 'add_domain') {
                $domain = trim($_GET['domain']);
                if (!empty($domain)) {
                    if (!isset($licenses[$index]['domains'])) {
                        $licenses[$index]['domains'] = [];
                    }
                    
                    // Check domain limit
                    $plan = get_plan_by_id($license['plan_id']);
                    $max_domains = $plan['id'] === 'enterprise' ? 999 : ($plan['id'] === 'professional' ? 3 : 1);
                    
                    if (count($licenses[$index]['domains']) < $max_domains) {
                        if (!in_array($domain, $licenses[$index]['domains'])) {
                            $licenses[$index]['domains'][] = $domain;
                        }
                    }
                }
            } elseif ($_GET['action'] === 'remove_domain') {
                $domain = trim($_GET['domain']);
                if (isset($licenses[$index]['domains']) && ($key = array_search($domain, $licenses[$index]['domains'])) !== false) {
                    unset($licenses[$index]['domains'][$key]);
                    $licenses[$index]['domains'] = array_values($licenses[$index]['domains']);
                }
            }
            break;
        }
    }
    
    file_put_contents(LICENSES_JSON, json_encode($licenses));
    redirect('licenses.php');
}

// Handle domain addition via POST
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_domain'])) {
    $license_key = $_POST['license_key'];
    $domain = trim($_POST['domain']);
    
    if (!empty($domain)) {
        $licenses = json_decode(file_get_contents(LICENSES_JSON), true);
        
        foreach ($licenses as $index => $license) {
            if ($license['key'] === $license_key && $license['user_id'] === $user_id) {
                if (!isset($licenses[$index]['domains'])) {
                    $licenses[$index]['domains'] = [];
                }
                
                // Check domain limit
                $plan = get_plan_by_id($license['plan_id']);
                $max_domains = $plan['id'] === 'enterprise' ? 999 : ($plan['id'] === 'professional' ? 3 : 1);
                
                if (count($licenses[$index]['domains']) < $max_domains) {
                    if (!in_array($domain, $licenses[$index]['domains'])) {
                        $licenses[$index]['domains'][] = $domain;
                    }
                }
                break;
            }
        }
        
        file_put_contents(LICENSES_JSON, json_encode($licenses));
        redirect('licenses.php');
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>License Management - <?php echo $settings['site_name']; ?></title>
    <link rel="stylesheet" href="styles.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <header class="header">
        <div class="container">
            <div class="logo">
                <h1><i class="fas fa-key"></i> <?php echo $settings['site_name']; ?></h1>
            </div>
            <nav class="nav">
                <a href="index.php">Home</a>
                <a href="pricing.php">Pricing</a>
                <?php if (is_admin()): ?>
                <a href="admin.php">Admin</a>
                <?php endif; ?>
                <a href="dashboard.php">Dashboard</a>
                <a href="licenses.php" class="active">Licenses</a>
                <a href="transactions.php">Transactions</a>
                <a href="logout.php">Logout</a>
            </nav>
            <div class="mobile-menu-btn">
                <i class="fas fa-bars"></i>
            </div>
        </div>
    </header>

    <main class="dashboard">
        <div class="container">
            <div class="dashboard-header">
                <h2>Your License Keys</h2>
                <a href="pricing.php" class="btn btn-primary">Purchase New License</a>
            </div>

            <?php if (empty($user_licenses)): ?>
            <div class="dashboard-section">
                <div class="alert alert-info">
                    <p>You don't have any license keys yet. <a href="pricing.php">Purchase your first license</a> to get started.</p>
                </div>
            </div>
            <?php else: ?>
            <?php foreach ($user_licenses as $license): 
                $plan = get_plan_by_id($license['plan_id']);
                $is_expired = strtotime($license['expires_at']) < time();
            ?>
            <div class="dashboard-section">
                <div class="license-header">
                    <h3>License Key: <code><?php echo $license['key']; ?></code></h3>
                    <span class="<?php echo ($license['status'] === 'active' && !$is_expired) ? 'status-active' : 'status-inactive'; ?>">
                        <?php echo ($license['status'] === 'active' && !$is_expired) ? 'Active' : 'Inactive'; ?>
                    </span>
                </div>
                
                <div class="license-details">
                    <div class="detail-item">
                        <strong>Plan:</strong> <?php echo $plan['name']; ?>
                    </div>
                    <div class="detail-item">
                        <strong>Expires:</strong> <?php echo date('F j, Y', strtotime($license['expires_at'])); ?>
                    </div>
                    <div class="detail-item">
                        <strong>Domains:</strong> 
                        <?php if (isset($license['domains']) && !empty($license['domains'])): ?>
                            <?php echo count($license['domains']); ?> of 
                            <?php echo $plan['id'] === 'enterprise' ? 'Unlimited' : ($plan['id'] === 'professional' ? '3' : '1'); ?>
                        <?php else: ?>
                            0 of <?php echo $plan['id'] === 'enterprise' ? 'Unlimited' : ($plan['id'] === 'professional' ? '3' : '1'); ?>
                        <?php endif; ?>
                    </div>
                </div>

                <?php if (isset($license['domains']) && !empty($license['domains'])): ?>
                <div class="domains-list">
                    <h4>Registered Domains</h4>
                    <ul>
                        <?php foreach ($license['domains'] as $domain): ?>
                        <li>
                            <?php echo $domain; ?>
                            <?php if ($license['status'] === 'active' && !$is_expired): ?>
                            <a href="licenses.php?action=remove_domain&license_key=<?php echo $license['key']; ?>&domain=<?php echo urlencode($domain); ?>" class="btn btn-danger btn-small" onclick="return confirm('Are you sure you want to remove this domain?')">Remove</a>
                            <?php endif; ?>
                        </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <?php endif; ?>

                <?php if ($license['status'] === 'active' && !$is_expired): ?>
                <div class="add-domain-form">
                    <h4>Add New Domain</h4>
                    <form method="POST" action="">
                        <input type="hidden" name="license_key" value="<?php echo $license['key']; ?>">
                        <div class="form-group-inline">
                            <input type="text" name="domain" placeholder="example.com" required>
                            <button type="submit" name="add_domain" class="btn btn-primary">Add Domain</button>
                        </div>
                    </form>
                </div>
                <?php endif; ?>

                <div class="license-instructions">
                    <h4>How to Use This License</h4>
                    <ol>
                        <li>Install the Vine AI plugin on your WordPress site</li>
                        <li>Go to the plugin settings page</li>
                        <li>Enter your license key: <code><?php echo $license['key']; ?></code></li>
                        <li>Save the settings to activate the plugin</li>
                        <li>The plugin will automatically register your domain</li>
                    </ol>
                </div>
            </div>
            <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </main>

    <footer class="footer">
        <div class="container">
            <div class="footer-content">
                <div class="footer-section">
                    <h3><?php echo $settings['site_name']; ?></h3>
                    <p>Advanced AI writing tool for WordPress that generates human-like content without restrictions.</p>
                </div>
                <div class="footer-section">
                    <h4>Quick Links</h4>
                    <ul>
                        <li><a href="index.php">Home</a></li>
                        <li><a href="pricing.php">Pricing</a></li>
                        <li><a href="dashboard.php">Dashboard</a></li>
                    </ul>
                </div>
                <div class="footer-section">
                    <h4>Support</h4>
                    <ul>
                        <li><a href="#">Documentation</a></li>
                        <li><a href="#">Contact Us</a></li>
                        <li><a href="#">Privacy Policy</a></li>
                        <li><a href="#">Terms of Service</a></li>
                    </ul>
                </div>
                <div class="footer-section">
                    <h4>Contact Info</h4>
                    <p><i class="fas fa-envelope"></i> <?php echo $settings['support_email']; ?></p>
                    <p><i class="fas fa-map-marker-alt"></i> <?php echo $settings['company_address']; ?></p>
                </div>
            </div>
            <div class="footer-bottom">
                <p>&copy; <?php echo date('Y'); ?> <?php echo $settings['company_name']; ?>. All rights reserved.</p>
            </div>
        </div>
    </footer>

    <script src="script.js"></script>
</body>
</html>