<?php
require_once 'config.php';

$settings = get_settings();
$plans = json_decode(file_get_contents(PLANS_JSON), true);
$active_plans = array_filter($plans, function($plan) {
    return $plan['is_active'];
});
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pricing - <?php echo $settings['site_name']; ?></title>
    <link rel="stylesheet" href="styles.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <header class="header">
        <div class="container">
            <div class="logo">
                <h1><i class="fas fa-key"></i> <?php echo $settings['site_name']; ?></h1>
            </div>
            <nav class="nav">
                <a href="index.php">Home</a>
                <a href="pricing.php" class="active">Pricing</a>
                <?php if (is_logged_in()): ?>
                    <?php if (is_admin()): ?>
                    <a href="admin.php">Admin</a>
                    <?php endif; ?>
                    <a href="dashboard.php">Dashboard</a>
                    <a href="logout.php">Logout</a>
                <?php else: ?>
                    <a href="register.php">Register</a>
                    <a href="login.php">Login</a>
                <?php endif; ?>
            </nav>
            <div class="mobile-menu-btn">
                <i class="fas fa-bars"></i>
            </div>
        </div>
    </header>

    <main class="main">
        <div class="container">
            <section class="pricing-section">
                <h2>Choose Your Plan</h2>
                <p class="subtitle">Select the perfect plan for your content needs. All plans include one year of updates and support.</p>
                
                <div class="pricing-grid">
                    <?php foreach ($active_plans as $plan): ?>
                    <div class="pricing-card highlighted">
                        <div class="pricing-header">
                            <h3><?php echo $plan['name']; ?></h3>
                            <div class="price">₦<?php echo number_format($plan['price']); ?></div>
                            <p>One-time payment, <?php echo $plan['duration']; ?> days validity</p>
                        </div>
                        <ul class="features">
                            <?php foreach ($plan['features'] as $feature): ?>
                            <li><i class="fas fa-check"></i> <?php echo $feature; ?></li>
                            <?php endforeach; ?>
                        </ul>
                        <div class="pricing-footer">
                            <a href="register.php?plan=<?php echo $plan['id']; ?>" class="btn btn-primary">Get Started</a>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </section>

            <section class="comparison-section">
                <h2>Plan Comparison</h2>
                <div class="comparison-table">
                    <table>
                        <thead>
                            <tr>
                                <th>Feature</th>
                                <?php foreach ($active_plans as $plan): ?>
                                <th><?php echo $plan['name']; ?></th>
                                <?php endforeach; ?>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>Websites</td>
                                <?php foreach ($active_plans as $plan): ?>
                                <td>
                                    <?php if ($plan['id'] === 'basic'): ?>1
                                    <?php elseif ($plan['id'] === 'professional'): ?>3
                                    <?php else: ?>Unlimited
                                    <?php endif; ?>
                                </td>
                                <?php endforeach; ?>
                            </tr>
                            <tr>
                                <td>License Duration</td>
                                <?php foreach ($active_plans as $plan): ?>
                                <td><?php echo $plan['duration']; ?> days</td>
                                <?php endforeach; ?>
                            </tr>
                            <tr>
                                <td>Support</td>
                                <?php foreach ($active_plans as $plan): ?>
                                <td>
                                    <?php if ($plan['id'] === 'basic'): ?>Email
                                    <?php elseif ($plan['id'] === 'professional'): ?>Priority
                                    <?php else: ?>24/7
                                    <?php endif; ?>
                                </td>
                                <?php endforeach; ?>
                            </tr>
                            <tr>
                                <td>Updates</td>
                                <?php foreach ($active_plans as $plan): ?>
                                <td><i class="fas fa-check"></i></td>
                                <?php endforeach; ?>
                            </tr>
                            <tr>
                                <td>Beta Features</td>
                                <?php foreach ($active_plans as $plan): ?>
                                <td>
                                    <?php if ($plan['id'] === 'enterprise'): ?>
                                    <i class="fas fa-check"></i>
                                    <?php else: ?>
                                    <i class="fas fa-times"></i>
                                    <?php endif; ?>
                                </td>
                                <?php endforeach; ?>
                            </tr>
                            <tr>
                                <td>Price</td>
                                <?php foreach ($active_plans as $plan): ?>
                                <td>₦<?php echo number_format($plan['price']); ?></td>
                                <?php endforeach; ?>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </section>

            <section class="faq-section">
                <h2>Frequently Asked Questions</h2>
                <div class="faq-list">
                    <div class="faq-item">
                        <h3>How do I install the plugin after purchase? <i class="fas fa-chevron-down"></i></h3>
                        <div class="faq-answer">
                            <p>After purchasing a license, you'll receive a license key. Install the Vine AI plugin on your WordPress site and enter the license key in the settings page to activate all features.</p>
                        </div>
                    </div>
                    <div class="faq-item">
                        <h3>Can I upgrade my plan later? <i class="fas fa-chevron-down"></i></h3>
                        <div class="faq-answer">
                            <p>Yes, you can upgrade your plan at any time. The remaining value of your current plan will be applied toward the upgrade cost.</p>
                        </div>
                    </div>
                    <div class="faq-item">
                        <h3>What payment methods do you accept? <i class="fas fa-chevron-down"></i></h3>
                        <div class="faq-answer">
                            <p>We accept all major credit cards, bank transfers, and mobile money through our secure Flutterwave payment gateway.</p>
                        </div>
                    </div>
                    <div class="faq-item">
                        <h3>Is there a money-back guarantee? <i class="fas fa-chevron-down"></i></h3>
                        <div class="faq-answer">
                            <p>Yes, we offer a 14-day money-back guarantee. If you're not satisfied with the plugin, contact our support team for a full refund.</p>
                        </div>
                    </div>
                    <div class="faq-item">
                        <h3>How do I renew my license? <i class="fas fa-chevron-down"></i></h3>
                        <div class="faq-answer">
                            <p>You'll receive a renewal notice via email before your license expires. You can then log into your account and renew your license with one click.</p>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </main>

    <footer class="footer">
        <div class="container">
            <div class="footer-content">
                <div class="footer-section">
                    <h3><?php echo $settings['site_name']; ?></h3>
                    <p>Advanced AI writing tool for WordPress that generates human-like content without restrictions.</p>
                </div>
                <div class="footer-section">
                    <h4>Quick Links</h4>
                    <ul>
                        <li><a href="index.php">Home</a></li>
                        <li><a href="pricing.php">Pricing</a></li>
                        <li><a href="register.php">Register</a></li>
                    </ul>
                </div>
                <div class="footer-section">
                    <h4>Support</h4>
                    <ul>
                        <li><a href="#">Documentation</a></li>
                        <li><a href="#">Contact Us</a></li>
                        <li><a href="#">Privacy Policy</a></li>
                        <li><a href="#">Terms of Service</a></li>
                    </ul>
                </div>
                <div class="footer-section">
                    <h4>Contact Info</h4>
                    <p><i class="fas fa-envelope"></i> <?php echo $settings['support_email']; ?></p>
                    <p><i class="fas fa-map-marker-alt"></i> <?php echo $settings['company_address']; ?></p>
                </div>
            </div>
            <div class="footer-bottom">
                <p>&copy; <?php echo date('Y'); ?> <?php echo $settings['company_name']; ?>. All rights reserved.</p>
            </div>
        </div>
    </footer>

    <script src="script.js"></script>
</body>
</html>