<?php
require_once 'config.php';

// Redirect if not logged in
if (!is_logged_in()) {
    redirect('login.php');
}

$settings = get_settings();
$user_id = $_SESSION['user_id'];

// Handle profile update
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_profile'])) {
    $email = trim($_POST['email']);
    $current_password = $_POST['current_password'];
    $new_password = $_POST['new_password'];
    $confirm_password = $_POST['confirm_password'];
    
    $users = json_decode(file_get_contents(USERS_JSON), true);
    $user_index = null;
    
    // Find current user
    foreach ($users as $index => $user) {
        if ($user['id'] === $user_id) {
            $user_index = $index;
            break;
        }
    }
    
    if ($user_index !== null) {
        // Update email
        $users[$user_index]['email'] = $email;
        
        // Update password if provided
        if (!empty($new_password)) {
            if (password_verify($current_password, $users[$user_index]['password'])) {
                if ($new_password === $confirm_password) {
                    $users[$user_index]['password'] = password_hash($new_password, PASSWORD_DEFAULT);
                    $success = 'Profile updated successfully.';
                } else {
                    $error = 'New passwords do not match.';
                }
            } else {
                $error = 'Current password is incorrect.';
            }
        } else {
            $success = 'Profile updated successfully.';
        }
        
        file_put_contents(USERS_JSON, json_encode($users));
        $_SESSION['user_email'] = $email;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Account Settings - <?php echo $settings['site_name']; ?></title>
    <link rel="stylesheet" href="styles.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <header class="header">
        <div class="container">
            <div class="logo">
                <h1><i class="fas fa-key"></i> <?php echo $settings['site_name']; ?></h1>
            </div>
            <nav class="nav">
                <a href="index.php">Home</a>
                <a href="pricing.php">Pricing</a>
                <?php if (is_admin()): ?>
                <a href="admin.php">Admin</a>
                <?php endif; ?>
                <a href="dashboard.php">Dashboard</a>
                <a href="licenses.php">Licenses</a>
                <a href="transactions.php">Transactions</a>
                <a href="settings.php" class="active">Settings</a>
                <a href="logout.php">Logout</a>
            </nav>
            <div class="mobile-menu-btn">
                <i class="fas fa-bars"></i>
            </div>
        </div>
    </header>

    <main class="dashboard">
        <div class="container">
            <div class="dashboard-header">
                <h2>Account Settings</h2>
            </div>

            <div class="dashboard-section">
                <h3>Profile Information</h3>
                
                <?php if (isset($error)): ?>
                <div class="alert alert-error">
                    <?php echo $error; ?>
                </div>
                <?php endif; ?>
                
                <?php if (isset($success)): ?>
                <div class="alert alert-success">
                    <?php echo $success; ?>
                </div>
                <?php endif; ?>
                
                <form method="POST" action="">
                    <input type="hidden" name="update_profile" value="1">
                    
                    <div class="form-group">
                        <label for="username">Username</label>
                        <input type="text" id="username" value="<?php echo $_SESSION['username']; ?>" disabled>
                        <p class="description">Username cannot be changed</p>
                    </div>
                    
                    <div class="form-group">
                        <label for="email">Email Address</label>
                        <input type="email" id="email" name="email" value="<?php echo $_SESSION['user_email']; ?>" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="current_password">Current Password</label>
                        <input type="password" id="current_password" name="current_password">
                        <p class="description">Leave blank to keep current password</p>
                    </div>
                    
                    <div class="form-group">
                        <label for="new_password">New Password</label>
                        <input type="password" id="new_password" name="new_password">
                    </div>
                    
                    <div class="form-group">
                        <label for="confirm_password">Confirm New Password</label>
                        <input type="password" id="confirm_password" name="confirm_password">
                    </div>
                    
                    <button type="submit" class="btn btn-primary">Update Profile</button>
                </form>
            </div>

            <div class="dashboard-section">
                <h3>Account Security</h3>
                <div class="security-info">
                    <div class="security-item">
                        <i class="fas fa-shield-alt"></i>
                        <div>
                            <h4>Last Login</h4>
                            <p><?php echo date('F j, Y, g:i a'); ?></p>
                        </div>
                    </div>
                    <div class="security-item">
                        <i class="fas fa-history"></i>
                        <div>
                            <h4>Account Created</h4>
                            <p>
                                <?php 
                                $users = json_decode(file_get_contents(USERS_JSON), true);
                                foreach ($users as $user) {
                                    if ($user['id'] === $user_id) {
                                        echo date('F j, Y', strtotime($user['created_at']));
                                        break;
                                    }
                                }
                                ?>
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <?php if (!is_admin()): ?>
            <div class="dashboard-section">
                <h3>Danger Zone</h3>
                <div class="danger-zone">
                    <p>Once you delete your account, there is no going back. Please be certain.</p>
                    <button class="btn btn-danger" onclick="confirmDelete()">Delete Account</button>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </main>

    <footer class="footer">
        <div class="container">
            <div class="footer-content">
                <div class="footer-section">
                    <h3><?php echo $settings['site_name']; ?></h3>
                    <p>Advanced AI writing tool for WordPress that generates human-like content without restrictions.</p>
                </div>
                <div class="footer-section">
                    <h4>Quick Links</h4>
                    <ul>
                        <li><a href="index.php">Home</a></li>
                        <li><a href="pricing.php">Pricing</a></li>
                        <li><a href="dashboard.php">Dashboard</a></li>
                    </ul>
                </div>
                <div class="footer-section">
                    <h4>Support</h4>
                    <ul>
                        <li><a href="#">Documentation</a></li>
                        <li><a href="#">Contact Us</a></li>
                        <li><a href="#">Privacy Policy</a></li>
                        <li><a href="#">Terms of Service</a></li>
                    </ul>
                </div>
                <div class="footer-section">
                    <h4>Contact Info</h4>
                    <p><i class="fas fa-envelope"></i> <?php echo $settings['support_email']; ?></p>
                    <p><i class="fas fa-map-marker-alt"></i> <?php echo $settings['company_address']; ?></p>
                </div>
            </div>
            <div class="footer-bottom">
                <p>&copy; <?php echo date('Y'); ?> <?php echo $settings['company_name']; ?>. All rights reserved.</p>
            </div>
        </div>
    </footer>

    <script>
        function confirmDelete() {
            if (confirm('Are you sure you want to delete your account? This action cannot be undone.')) {
                window.location.href = 'delete_account.php';
            }
        }
    </script>
    <script src="script.js"></script>
</body>
</html>