<?php
require_once 'config.php';

// Redirect if not logged in
if (!is_logged_in()) {
    redirect('login.php');
}

$settings = get_settings();

// Get transaction reference from URL
$tx_ref = isset($_GET['tx_ref']) ? $_GET['tx_ref'] : '';

// Find transaction
$transactions = json_decode(file_get_contents(TRANSACTIONS_JSON), true);
$transaction = null;
$license = null;

foreach ($transactions as $t) {
    if ($t['tx_ref'] === $tx_ref && $t['user_id'] === $_SESSION['user_id']) {
        $transaction = $t;
        break;
    }
}

// Find license for this transaction
if ($transaction) {
    $licenses = json_decode(file_get_contents(LICENSES_JSON), true);
    foreach ($licenses as $l) {
        if ($l['transaction_id'] === $transaction['id'] && $l['user_id'] === $_SESSION['user_id']) {
            $license = $l;
            break;
        }
    }
}

// Redirect if no transaction or license found
if (!$transaction || !$license) {
    redirect('dashboard.php');
}

$plan = get_plan_by_id($transaction['plan_id']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Successful - <?php echo $settings['site_name']; ?></title>
    <link rel="stylesheet" href="styles.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <header class="header">
        <div class="container">
            <div class="logo">
                <h1><i class="fas fa-key"></i> <?php echo $settings['site_name']; ?></h1>
            </div>
            <nav class="nav">
                <a href="index.php">Home</a>
                <a href="pricing.php">Pricing</a>
                <?php if (is_admin()): ?>
                <a href="admin.php">Admin</a>
                <?php endif; ?>
                <a href="dashboard.php">Dashboard</a>
                <a href="logout.php">Logout</a>
            </nav>
            <div class="mobile-menu-btn">
                <i class="fas fa-bars"></i>
            </div>
        </div>
    </header>

    <main class="main">
        <div class="container">
            <div class="success-container">
                <div class="success-icon">
                    <i class="fas fa-check-circle"></i>
                </div>
                
                <h2>Payment Successful!</h2>
                <p class="success-message">Thank you for your purchase. Your license has been activated.</p>
                
                <div class="success-details">
                    <div class="detail-card">
                        <h3>Transaction Details</h3>
                        <div class="detail-item">
                            <strong>Transaction ID:</strong> <?php echo $transaction['tx_ref']; ?>
                        </div>
                        <div class="detail-item">
                            <strong>Plan:</strong> <?php echo $plan['name']; ?>
                        </div>
                        <div class="detail-item">
                            <strong>Amount:</strong> ₦<?php echo number_format($transaction['amount'], 2); ?>
                        </div>
                        <div class="detail-item">
                            <strong>Date:</strong> <?php echo date('F j, Y, g:i a', strtotime($transaction['created_at'])); ?>
                        </div>
                    </div>
                    
                    <div class="detail-card">
                        <h3>Your License Key</h3>
                        <div class="license-key">
                            <?php echo $license['key']; ?>
                            <button class="copy-btn" onclick="copyLicenseKey('<?php echo $license['key']; ?>')">
                                <i class="fas fa-copy"></i> Copy
                            </button>
                        </div>
                        <p class="license-expiry">Expires: <?php echo date('F j, Y', strtotime($license['expires_at'])); ?></p>
                    </div>
                </div>
                
                <div class="success-actions">
                    <a href="licenses.php" class="btn btn-primary">Manage Licenses</a>
                    <a href="dashboard.php" class="btn btn-secondary">Go to Dashboard</a>
                    <a href="invoice.php?tx_ref=<?php echo $transaction['tx_ref']; ?>" class="btn btn-secondary">Download Invoice</a>
                </div>
                
                <div class="installation-instructions">
                    <h3>How to Install Your Plugin</h3>
                    <ol>
                        <li>Download the Vine AI WordPress plugin from your dashboard</li>
                        <li>Install and activate the plugin on your WordPress site</li>
                        <li>Go to the plugin settings page</li>
                        <li>Enter your license key: <code><?php echo $license['key']; ?></code></li>
                        <li>Save the settings to activate all features</li>
                    </ol>
                </div>
            </div>
        </div>
    </main>

    <footer class="footer">
        <div class="container">
            <div class="footer-content">
                <div class="footer-section">
                    <h3><?php echo $settings['site_name']; ?></h3>
                    <p>Advanced AI writing tool for WordPress that generates human-like content without restrictions.</p>
                </div>
                <div class="footer-section">
                    <h4>Quick Links</h4>
                    <ul>
                        <li><a href="index.php">Home</a></li>
                        <li><a href="pricing.php">Pricing</a></li>
                        <li><a href="dashboard.php">Dashboard</a></li>
                    </ul>
                </div>
                <div class="footer-section">
                    <h4>Support</h4>
                    <ul>
                        <li><a href="#">Documentation</a></li>
                        <li><a href="#">Contact Us</a></li>
                        <li><a href="#">Privacy Policy</a></li>
                        <li><a href="#">Terms of Service</a></li>
                    </ul>
                </div>
                <div class="footer-section">
                    <h4>Contact Info</h4>
                    <p><i class="fas fa-envelope"></i> <?php echo $settings['support_email']; ?></p>
                    <p><i class="fas fa-map-marker-alt"></i> <?php echo $settings['company_address']; ?></p>
                </div>
            </div>
            <div class="footer-bottom">
                <p>&copy; <?php echo date('Y'); ?> <?php echo $settings['company_name']; ?>. All rights reserved.</p>
            </div>
        </div>
    </footer>

    <script>
        function copyLicenseKey(licenseKey) {
            navigator.clipboard.writeText(licenseKey).then(() => {
                alert('License key copied to clipboard!');
            });
        }
    </script>
    <script src="script.js"></script>
</body>
</html>