<?php
require_once 'config.php';

// Redirect if not logged in
if (!is_logged_in()) {
    redirect('login.php');
}

$settings = get_settings();
$user_id = $_SESSION['user_id'];
$user_transactions = get_user_transactions($user_id);

// For admin users, show all transactions
if (is_admin()) {
    $user_transactions = get_all_transactions();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Transaction History - <?php echo $settings['site_name']; ?></title>
    <link rel="stylesheet" href="styles.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <header class="header">
        <div class="container">
            <div class="logo">
                <h1><i class="fas fa-key"></i> <?php echo $settings['site_name']; ?></h1>
            </div>
            <nav class="nav">
                <a href="index.php">Home</a>
                <a href="pricing.php">Pricing</a>
                <?php if (is_admin()): ?>
                <a href="admin.php">Admin</a>
                <?php endif; ?>
                <a href="dashboard.php">Dashboard</a>
                <a href="licenses.php">Licenses</a>
                <a href="transactions.php" class="active">Transactions</a>
                <a href="logout.php">Logout</a>
            </nav>
            <div class="mobile-menu-btn">
                <i class="fas fa-bars"></i>
            </div>
        </div>
    </header>

    <main class="dashboard">
        <div class="container">
            <div class="dashboard-header">
                <h2>Transaction History</h2>
            </div>

            <?php if (empty($user_transactions)): ?>
            <div class="dashboard-section">
                <div class="alert alert-info">
                    <p>No transactions found.</p>
                </div>
            </div>
            <?php else: ?>
            <div class="dashboard-section">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Transaction ID</th>
                                <?php if (is_admin()): ?>
                                <th>User</th>
                                <?php endif; ?>
                                <th>Plan</th>
                                <th>Amount</th>
                                <th>Date</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($user_transactions as $transaction): 
                                $plan = get_plan_by_id($transaction['plan_id']);
                                $user = is_admin() ? get_user_by_id($transaction['user_id']) : null;
                            ?>
                            <tr>
                                <td><?php echo $transaction['tx_ref']; ?></td>
                                <?php if (is_admin()): ?>
                                <td><?php echo $user['username']; ?></td>
                                <?php endif; ?>
                                <td><?php echo $plan['name']; ?></td>
                                <td>₦<?php echo number_format($transaction['amount'], 2); ?></td>
                                <td><?php echo date('M j, Y H:i', strtotime($transaction['created_at'])); ?></td>
                                <td>
                                    <span class="status-active">Completed</span>
                                </td>
                                <td>
                                    <a href="invoice.php?tx_ref=<?php echo $transaction['tx_ref']; ?>" class="btn btn-secondary btn-small">View Invoice</a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                
                <?php if (count($user_transactions) > 10): ?>
                <div class="pagination">
                    <a href="#" class="btn btn-secondary">Previous</a>
                    <a href="#" class="btn btn-primary">1</a>
                    <a href="#" class="btn btn-secondary">2</a>
                    <a href="#" class="btn btn-secondary">3</a>
                    <a href="#" class="btn btn-secondary">Next</a>
                </div>
                <?php endif; ?>
            </div>
            <?php endif; ?>
        </div>
    </main>

    <footer class="footer">
        <div class="container">
            <div class="footer-content">
                <div class="footer-section">
                    <h3><?php echo $settings['site_name']; ?></h3>
                    <p>Advanced AI writing tool for WordPress that generates human-like content without restrictions.</p>
                </div>
                <div class="footer-section">
                    <h4>Quick Links</h4>
                    <ul>
                        <li><a href="index.php">Home</a></li>
                        <li><a href="pricing.php">Pricing</a></li>
                        <li><a href="dashboard.php">Dashboard</a></li>
                    </ul>
                </div>
                <div class="footer-section">
                    <h4>Support</h4>
                    <ul>
                        <li><a href="#">Documentation</a></li>
                        <li><a href="#">Contact Us</a></li>
                        <li><a href="#">Privacy Policy</a></li>
                        <li><a href="#">Terms of Service</a></li>
                    </ul>
                </div>
                <div class="footer-section">
                    <h4>Contact Info</h4>
                    <p><i class="fas fa-envelope"></i> <?php echo $settings['support_email']; ?></p>
                    <p><i class="fas fa-map-marker-alt"></i> <?php echo $settings['company_address']; ?></p>
                </div>
            </div>
            <div class="footer-bottom">
                <p>&copy; <?php echo date('Y'); ?> <?php echo $settings['company_name']; ?>. All rights reserved.</p>
            </div>
        </div>
    </footer>

    <script src="script.js"></script>
</body>
</html>